import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;

public class ContextMenuDemo extends Application {   
  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {   
    ContextMenu contextMenu = new ContextMenu();       
    MenuItem menuItemNew = new MenuItem("Nowy",
      new ImageView("image/new.gif"));
    MenuItem menuItemOpen = new MenuItem("Otwórz",
      new ImageView("image/open.gif"));
    MenuItem menuItemPrint = new MenuItem("Drukuj",
      new ImageView("image/print.gif"));
    MenuItem menuItemExit = new MenuItem("Zakończ");
    contextMenu.getItems().addAll(menuItemNew, menuItemOpen,
      menuItemPrint, menuItemExit);
   
    Pane pane = new Pane();
    Scene scene = new Scene(pane, 300, 250);  
    primaryStage.setTitle("ContextMenuDemo"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
    
    pane.setOnMousePressed(
      e -> contextMenu.show(pane, e.getScreenX(), e.getScreenY()));
    
    menuItemNew.setOnAction(e -> System.out.println("Nowy"));
    menuItemOpen.setOnAction(e -> System.out.println("Otwórz"));
    menuItemPrint.setOnAction(e -> System.out.println("Drukuj"));
    menuItemExit.setOnAction(e -> System.exit(0));
  }

  /**
   * Metoda main jest potrzebna tylko w środowiskach IDE z ograniczoną obsługą platformy JavaFX.
   * Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
