public class BST<E> implements Tree<E> {
  protected TreeNode<E> root;
  protected int size = 0;
  protected java.util.Comparator<E> c;

  /** Tworzy domylne drzewo BST z komparatorem opartym na porzdku naturalnym */
  public BST() {
    this.c = (e1, e2) -> ((Comparable<E>)e1).compareTo(e2);
  }

  /** Tworzenie drzewa BST z okrelonym komparatorem */
  public BST(java.util.Comparator<E> c) {
    this.c = c;
  }

  /** Tworzenie drzewa binarnego na podstawie tablicy obiektw */
  public BST(E[] objects) {
    this.c = (e1, e2) -> ((Comparable<E>)e1).compareTo(e2);
    for (int i = 0; i < objects.length; i++)
      add(objects[i]);
  }

  @Override /** Zwraca true, jeli element znajduje si w drzewie */
  public boolean search(E e) {
    TreeNode<E> current = root; // Rozpoczynanie od korzenia

    while (current != null) {
      if (c.compare(e, current.element) < 0) {
        current = current.left;
      }
      else if (c.compare(e, current.element) > 0) {
        current = current.right;
      }
      else // Element pasuje to current.element
        return true; // Element zosta znaleziony
    }

    return false;
  }

  @Override /** Wstawianie elementu e do drzewa binarnego.
   * Zwraca true po udanym wstawieniu elementu */
  public boolean insert(E e) {
    if (root == null)
      root = createNewNode(e); // Tworzy nowy korze
    else {
      // Znajdowanie rodzica
      TreeNode<E> parent = null;
      TreeNode<E> current = root;
      while (current != null)
        if (c.compare(e, current.element) < 0) {
          parent = current;
          current = current.left;
        }
        else if (c.compare(e, current.element) > 0) {
          parent = current;
          current = current.right;
        }
        else
          return false; // Powtarzajcy si wze nie jest wstawiany

      // Tworzenie nowego wza i doczanie go do rodzica
      if (c.compare(e, parent.element) < 0)
        parent.left = createNewNode(e);
      else
        parent.right = createNewNode(e);
    }

    size++;
    return true; // Element zosta poprawnie wstawiony
  }

  protected TreeNode<E> createNewNode(E e) {
    return new TreeNode<>(e);
  }

  @Override /** Odwiedzanie wzw od korzenia metod inorder */
  public void inorder() {
    inorder(root);
  }

  /** Odwiedzanie wzw od poddrzewa metod inorder */
  protected void inorder(TreeNode<E> root) {
    if (root == null) return;
    inorder(root.left);
    System.out.print(root.element + " ");
    inorder(root.right);
  }

  @Override /** Odwiedzanie wzw od korzenia metod postorder */
  public void postorder() {
    postorder(root);
  }

  /** Odwiedzanie wzw od poddrzewa metod postorder */
  protected void postorder(TreeNode<E> root) {
    if (root == null) return;
    postorder(root.left);
    postorder(root.right);
    System.out.print(root.element + " ");
  }

  @Override /** Odwiedzanie wzw od korzenia metod preorder */
  public void preorder() {
    preorder(root);
  }

  /** Odwiedzanie wzw od poddrzewa metod preorder */
  protected void preorder(TreeNode<E> root) {
    if (root == null) return;
    System.out.print(root.element + " ");
    preorder(root.left);
    preorder(root.right);
  }

  /** Klasa wewntrzna jest statyczna, poniewa nie uywa
      adnych skadowych instancji zdefiniowanych w klasie zewntrznej */
  public static class TreeNode<E> {
    protected E element;
    protected TreeNode<E> left;
    protected TreeNode<E> right;

    public TreeNode(E e) {
      element = e;
    }
  }

  @Override /** Pobieranie liczby wzw w drzewie */
  public int getSize() {
    return size;
  }

  /** Zwraca korze drzewa */
  public TreeNode<E> getRoot() {
    return root;
  }

  /** Zwraca ciek z korzenia do okrelonego elementu */
  public java.util.ArrayList<TreeNode<E>> path(E e) {
    java.util.ArrayList<TreeNode<E>> list =
      new java.util.ArrayList<>();
    TreeNode<E> current = root; // Rozpoczynanie od korzenia

    while (current != null) {
      list.add(current); // Dodawanie wza do listy
      if (c.compare(e, current.element) < 0) {
        current = current.left;
      }
      else if (c.compare(e, current.element) > 0) {
        current = current.right;
      }
      else
        break;
    }

    return list; // Zwraca kolekcji ArrayList wzw
  }

  @Override /** Usuwanie elementu z drzewa binarnego.
   * Zwraca true po udanym usuniciu elementu.
   * Zwraca false, jeli elementu nie ma w drzewie */
  public boolean delete(E e) {
    // Znajdowanie usuwanego wza i jego rodzica
    TreeNode<E> parent = null;
    TreeNode<E> current = root;
    while (current != null) {
      if (c.compare(e, current.element) < 0) {
        parent = current;
        current = current.left;
      }
      else if (c.compare(e, current.element) > 0) {
        parent = current;
        current = current.right;
      }
      else
        break; // Element znajduje si w drzewie wskazywanym przez current
    }

    if (current == null)
      return false; // Elementu nie ma w drzewie

    // Scenariusz 1. current nie ma lewego dziecka
    if (current.left == null) {
      // czenie rodzica z prawym dzieckiem wza current
      if (parent == null) {
        root = current.right;
      }
      else {
        if (c.compare(e, parent.element) < 0)
          parent.left = current.right;
        else
          parent.right = current.right;
      }
    }
    else {
      // Scenariusz 2. Wze current ma lewe dziecko.
      // Szukanie pierwszego od prawej wza w lewym poddrzewie wza
      // current i rodzica
      TreeNode<E> parentOfRightMost = current;
      TreeNode<E> rightMost = current.left;

      while (rightMost.right != null) {
        parentOfRightMost = rightMost;
        rightMost = rightMost.right; // Przechodzenie w prawo
      }

      // Zastpowanie elementu w wle current elementem z wza rightMost
      current.element = rightMost.element;

      // Usuwanie wza rightMost
      if (parentOfRightMost.right == rightMost)
        parentOfRightMost.right = rightMost.left;
      else
        // Specjalny przypadek: parentOfRightMost == current
        parentOfRightMost.left = rightMost.left;
    }

    size--; // Zmniejszanie wielkoci drzewa
    return true; // Element zosta usunity
  }

  @Override /** Pobieranie iteratora. Uywanie porzdku inorder. */
  public java.util.Iterator<E> iterator() {
    return new InorderIterator();
  }

  // Klasa wewntrzna InorderIterator
  private class InorderIterator implements java.util.Iterator<E> {
    // Zapisywanie elementw na licie
    private java.util.ArrayList<E> list =
      new java.util.ArrayList<>();
    private int current = 0; // Biecy element

    public InorderIterator() {
      inorder(); // Przechodzenie drzewa binarnego i zapisywanie elementw na licie
    }

    /** Odwiedzanie elementw od korzenia w porzdku inorder */
    private void inorder() {
      inorder(root);
    }

    /** Odwiedzanie elementw od poddrzewa w porzdku inorder */
    private void inorder(TreeNode<E> root) {
      if (root == null) return;
      inorder(root.left);
      list.add(root.element);
      inorder(root.right);
    }

    @Override /** Pozostay elementy do odwiedzenia? */
    public boolean hasNext() {
      if (current < list.size())
        return true;

      return false;
    }

    @Override /** Pobieranie biecego elementu i przechodzenie do nastpnego */
    public E next() {
      return list.get(current++);
    }

    @Override // Usuwanie elementu zwrconego przez ostatnie wywoanie next()
    public void remove() {
      if (current == 0) // Metoda next() nie zostaa jeszcze wywoana
        throw new IllegalStateException();

      delete(list.get(--current));
      list.clear(); // Oprnianie listy
      inorder(); // Ponowne tworzenie listy
    }
  }

  @Override /** Usuwanie wszystkich elementw drzewa */
  public void clear() {
    root = null;
    size = 0;
  }
}
