/*
 * Decompiled with CFR 0.152.
 */
import javafx.application.Application;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class LoanCalculator
extends Application {
    private TextField tfAnnualInterestRate = new TextField();
    private TextField tfNumberOfYears = new TextField();
    private TextField tfLoanAmount = new TextField();
    private TextField tfMonthlyPayment = new TextField();
    private TextField tfTotalPayment = new TextField();
    private Button btCalculate = new Button("Calculate");

    public void start(Stage primaryStage) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.add((Node)new Label("Annual Interest Rate:"), 0, 0);
        gridPane.add((Node)this.tfAnnualInterestRate, 1, 0);
        gridPane.add((Node)new Label("Number of Years:"), 0, 1);
        gridPane.add((Node)this.tfNumberOfYears, 1, 1);
        gridPane.add((Node)new Label("Loan Amount:"), 0, 2);
        gridPane.add((Node)this.tfLoanAmount, 1, 2);
        gridPane.add((Node)new Label("Monthly Payment:"), 0, 3);
        gridPane.add((Node)this.tfMonthlyPayment, 1, 3);
        gridPane.add((Node)new Label("Total Payment:"), 0, 4);
        gridPane.add((Node)this.tfTotalPayment, 1, 4);
        gridPane.add((Node)this.btCalculate, 1, 5);
        gridPane.setAlignment(Pos.CENTER);
        this.tfAnnualInterestRate.setAlignment(Pos.BOTTOM_RIGHT);
        this.tfNumberOfYears.setAlignment(Pos.BOTTOM_RIGHT);
        this.tfLoanAmount.setAlignment(Pos.BOTTOM_RIGHT);
        this.tfMonthlyPayment.setAlignment(Pos.BOTTOM_RIGHT);
        this.tfTotalPayment.setAlignment(Pos.BOTTOM_RIGHT);
        this.tfMonthlyPayment.setEditable(false);
        this.tfTotalPayment.setEditable(false);
        GridPane.setHalignment((Node)this.btCalculate, (HPos)HPos.RIGHT);
        this.btCalculate.setOnAction(e -> this.calculateLoanPayment());
        Scene scene = new Scene((Parent)gridPane, 400.0, 250.0);
        primaryStage.setTitle("LoanCalculator");
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    private void calculateLoanPayment() {
        double interest = Double.parseDouble(this.tfAnnualInterestRate.getText());
        int year = Integer.parseInt(this.tfNumberOfYears.getText());
        double loanAmount = Double.parseDouble(this.tfLoanAmount.getText());
        Loan loan = new Loan(interest, year, loanAmount);
        this.tfMonthlyPayment.setText(String.format("$%.2f", loan.getMonthlyPayment()));
        this.tfTotalPayment.setText(String.format("$%.2f", loan.getTotalPayment()));
    }

    public static void main(String[] args) {
        LoanCalculator.launch((String[])args);
    }
}

