/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class TicTacToe
extends JApplet {
    private char whoseTurn = (char)88;
    private Cell[][] cells = new Cell[3][3];
    private JLabel jlblStatus = new JLabel("X's turn to play");

    public TicTacToe() {
        JPanel p = new JPanel(new GridLayout(3, 3, 0, 0));
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                Cell cell = new Cell();
                this.cells[i][j] = cell;
                p.add(cell);
                ++j;
            }
            ++i;
        }
        p.setBorder(new LineBorder(Color.red, 1));
        this.jlblStatus.setBorder(new LineBorder(Color.yellow, 1));
        this.add((Component)p, "Center");
        this.add((Component)this.jlblStatus, "South");
    }

    public boolean isFull() {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                if (this.cells[i][j].getToken() == ' ') {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean isWon(char token) {
        int i = 0;
        while (i < 3) {
            if (this.cells[i][0].getToken() == token && this.cells[i][1].getToken() == token && this.cells[i][2].getToken() == token) {
                return true;
            }
            ++i;
        }
        int j = 0;
        while (j < 3) {
            if (this.cells[0][j].getToken() == token && this.cells[1][j].getToken() == token && this.cells[2][j].getToken() == token) {
                return true;
            }
            ++j;
        }
        if (this.cells[0][0].getToken() == token && this.cells[1][1].getToken() == token && this.cells[2][2].getToken() == token) {
            return true;
        }
        return this.cells[0][2].getToken() == token && this.cells[1][1].getToken() == token && this.cells[2][0].getToken() == token;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("TicTacToe");
        TicTacToe applet = new TicTacToe();
        frame.add((Component)applet, "Center");
        frame.setSize(300, 300);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public class Cell
    extends JPanel {
        private char token = (char)32;

        public Cell() {
            this.setBorder(new LineBorder(Color.black, 1));
            this.addMouseListener(new MyMouseListener());
        }

        public char getToken() {
            return this.token;
        }

        public void setToken(char c) {
            this.token = c;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.token == 'X') {
                g.drawLine(10, 10, this.getWidth() - 10, this.getHeight() - 10);
                g.drawLine(this.getWidth() - 10, 10, 10, this.getHeight() - 10);
            } else if (this.token == 'O') {
                g.drawOval(10, 10, this.getWidth() - 20, this.getHeight() - 20);
            }
        }

        private class MyMouseListener
        extends MouseAdapter {
            private MyMouseListener() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (Cell.this.token == ' ' && TicTacToe.this.whoseTurn != ' ') {
                    Cell.this.setToken(TicTacToe.this.whoseTurn);
                    if (TicTacToe.this.isWon(TicTacToe.this.whoseTurn)) {
                        TicTacToe.this.jlblStatus.setText(String.valueOf(TicTacToe.this.whoseTurn) + " won! The game is over");
                        TicTacToe.this.whoseTurn = ' ';
                    } else if (TicTacToe.this.isFull()) {
                        TicTacToe.this.jlblStatus.setText("Draw! The game is over");
                        TicTacToe.this.whoseTurn = ' ';
                    } else {
                        TicTacToe.this.whoseTurn = TicTacToe.this.whoseTurn == 'X' ? (char)'O' : 'X';
                        TicTacToe.this.jlblStatus.setText(String.valueOf(TicTacToe.this.whoseTurn) + "'s turn");
                    }
                }
            }
        }
    }
}

