/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RawCommonAccessor;

class RawAccessor
extends RawCommonAccessor {
    static final int MAXLENGTH_NEW = 2000;
    static final int MAXLENGTH_OLD = 255;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:30:28_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    RawAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        this.init(oracleStatement, 23, 15, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    RawAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        this.init(oracleStatement, 23, 15, s2, false);
        this.initForDescribe(23, n2, bl, n3, n4, n5, n6, n7, s2, null);
        int n8 = oracleStatement.maxFieldSize;
        if (n8 > 0 && (n2 == 0 || n8 < n2)) {
            n2 = n8;
        }
        this.initForDataAccess(0, n2, null);
    }

    @Override
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = this.statement.connection.getVersionNumber() >= 8000 ? 2000 : 255;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.byteLength = this.internalTypeMaxLength + 2;
    }

    @Override
    byte[] getBytes(int n2) throws SQLException {
        byte[] byArray = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            int n3 = this.columnIndex + this.byteLength * n2;
            byArray = new byte[s2];
            System.arraycopy(this.rowSpaceByte, n3 + 2, byArray, 0, s2);
        }
        return byArray;
    }
}

