#include <iostream>
#include <unordered_set>
#include <unordered_map>
#include <utility>

using namespace std;

int main()
{
   unordered_multiset<string> names;
   names.insert("Romeo");
   names.insert("Julia");
   names.insert("Romeo"); // Funkcja names.count("Romeo") zwraca teraz liczbę 2
   cout << "Liczba Romeów: " << names.count("Romeo") << endl;
   cout << "Liczba Julii: " << names.count("Julia") << endl;
   names.erase("Julia"); // Funkcja names.count("Julia") zwraca teraz liczbę 0
   cout << "Liczba Julii: " << names.count("Julia") << endl;
   names.erase("Julia");
      // Nie ma żadnego skutku: w wielozbiorze nie ma już ciągu "Julia"
   cout << "Liczba Julii: " << names.count("Julia") << endl;

   unordered_multimap<string, string> friends;
   friends.insert(make_pair("Tomasz", "Daria")); // Daria przyjaźni się z Tomaszem.
   friends.insert(make_pair("Tomasz", "Henryk")); // Henryk też się z nim przyjaźni.

   auto tom_range = friends.equal_range("Tomasz");
      // pair<unordered_multimap<string, string>::iterator>
   cout << "Przyjaciele Tomasza: ";
   for (auto pos = tom_range.first; pos != tom_range.second; pos++)
   {
      cout << pos->second << " ";
   }
   cout << endl;

   bool found = false;
   for (auto pos = tom_range.first; !found && pos != tom_range.second; pos++)
   {
      if (pos->second == "Daria")
      {
         found = true;
         friends.erase(pos);
         cout << "Daria nie przyjaźni się już z Tomaszem" << endl;
      }
   }

   cout << "Liczba pozostałych przyjaciół Tomasza: "
      << friends.count("Tomasz") << endl;

   return 0;
}

