#include <iostream>
#include <fstream>
#include <string>
#include <unordered_set>

using namespace std;

unordered_set<string> read_words(string filename)
{
   ifstream in(filename);
   unordered_set<string> result;
   string input;
   while (in >> input)
   {
      // Zanim wyrazy zostaną dodane do słownika, zamień w tekście duże litery na małe i podziel go w miejscach, gdzie nie ma liter.
      string word;
      for (int i = 0; i < input.length(); i++)
      {
         if ('a' <= input[i] && input[i] <= 'z')
         {
            word.push_back(input[i]);
         }
         else if ('A' <= input[i] && input[i] <= 'Z')
         {
            word.push_back(input[i] + 'a' - 'A');
         }
         else
         {
            result.insert(word);
            word = "";
         }
      }
      result.insert(word);
   }
   // Do zbioru mógł być wstawiony pusty wyraz, jeśli
   // znaki nie będące literami wystąpiły na początku lub na końcu
   // danych wejściowych.
   result.erase("");

   return result;
}

int main()
{
   unordered_set<string> dictionary = read_words("words.txt");
   unordered_set<string> book = read_words("alice.txt");

   // Przejdź przez wszystkie wyrazy książki.

   for (auto iter = book.begin(); iter != book.end(); iter++)
   {
      string word = *iter;

      // Wyświetl wyraz, jeśli nie występuje w słowniku.

      if (dictionary.count(word) == 0)
      {
         cout << word << endl;
      }
   }
}

