#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

#include "employee.h"

/** 
   Wyświetla wszystkie elementy tablicy.
   @param a tablica do wyświetlenia
   @param size liczba elementów tablicy a
*/
void print(int a[], int size)
{  
   for (int i = 0; i < size; i++)
   {
      cout << a[i] << " ";
   }
   cout << endl;
}

bool operator<(const Employee& a, const Employee& b)
{
   return a.get_salary() < b.get_salary();
}

int main()
{  
   const int SIZE = 5;
   int values[SIZE] = { 48, 35, 78, 63, 51 };

   sort(values, values + SIZE);

   print(values, SIZE);

   vector<Employee> staff(SIZE);
   staff[0] = Employee("Krakus, Krystian", 48000.0);
   staff[1] = Employee("Hakiel, Halina", 35000.0);
   staff[2] = Employee("Lem, Lech", 78000.0);
   staff[3] = Employee("Renifer, Rudolf", 63000.0);
   staff[4] = Employee("Sasanka, Sabina", 51000.0);

   sort(staff.begin(), staff.end());

   for (int i = 0; i < staff.size(); i++)
   {
      cout << staff[i].get_name() << " " << staff[i].get_salary() << endl;
   }

   return 0;
}

