#include <cstdlib>
#include <ctime>
#include <iostream>

using namespace std;

/**
   Sortuje tablicę przy użyciu sortowania przez wstawianie.
   @param a tablica do posortowania
*/
void insertion_sort(int a[], int size)
{
   for (int i = 1; i < size; i++)
   {
      int next = a[i];
      // Przenieś wszystkie większe elementy dalej.
      int j = i;
      while (j > 0 && a[j - 1] > next)
      {
         a[j] = a[j - 1];
         j--;
      }
      // Wstaw element.
      a[j] = next;
   }
}

/** 
   Wyświetla wszystkie elementy tablicy.
   @param a tablica do wyświetlenia
   @param size liczba elementów tablicy a
*/
void print(int a[], int size)
{  
   for (int i = 0; i < size; i++)
   {
      cout << a[i] << " ";
   }
   cout << endl;
}

int main()
{  
   srand(time(0));
   const int SIZE = 20;
   int values[SIZE];
   for (int i = 0; i < SIZE; i++)
   {
      values[i] = rand() % 100;
   }
   print(values, SIZE);
   insertion_sort(values, SIZE);
   print(values, SIZE);
   return 0;
}

