#include <iostream>
#include <sstream>
#include <string>

using namespace std;

class Question
{
public:
   /**
      Konstruuje pytanie z pustym tekstem i odpowiedzią.
   */
   Question();

   /**
      @param question_text tekst pytania
   */
   void set_text(string question_text);

   /**
      @param correct_response właściwa odpowiedź na pytanie
   */
   void set_answer(string correct_response);

   /**
      @param response odpowiedź do sprawdzenia
      @return wartość true, jeśli odpowiedź jest poprawna, w przeciwnym razie wartość false
   */
   bool check_answer(string response) const;   

   /**
      Wyświetla pytanie.
   */
   void display() const;
private:
   string text;
   string answer;
};

Question::Question() 
{
}

void Question::set_text(string question_text)   
{
   text = question_text;
}

void Question::set_answer(string correct_response)
{
   answer = correct_response;
}

bool Question::check_answer(string response) const
{
   return response == answer;
}

void Question::display() const
{
   cout << text << endl;
}

int main()
{
   string response;
   cout << boolalpha; // Pokazuj wartości logiczne jako ciągi true, false.

   Question q1;
   q1.set_text("Kto jest twórcą języka C++?");
   q1.set_answer("Bjarne Stroustrup");

   q1.display();
   cout << "Twoja odpowiedź: ";
   getline(cin, response);
   cout << q1.check_answer(response) << endl;

   return 0;
}

