#Ta wersja

Ten kod pochodzi pierwotnie z https://github.com/rpryzant/causal-bert-pytorch
W momencie pisania oryginalny kod zawierał błąd
 (https://github.com/rpryzant/causal-bert-pytorch/issues/6)
co spowodowało, że użycie jednej z metod (.ATE()) było niewskazane.
Ta wersja kodu naprawia ten błąd.

Poprawiłem także drobne błędy w oryginalnej zawartości pliku README.md

Poniżej zaczyna się oryginalny plik README.md:

# Przyczynowy Bert – w Pytorch!
Implementacja Pytorcha ["Adapting Text Embeddings for Causal Inference" by Victor Veitch, Dhanya Sridhar, and David M. Blei](https://arxiv.org/pdf/1905.12741.pdf). 

# Szybki start

```
pip install -r requirements.txt
python CausalBert.py
```


Spowoduje to przeszkolenie systemu na niektórych danych testowych i obliczenie średniego efektu leczenia (ATE). 

# Opis

Jako dane wejściowe system oczekuje danych, w których każdy wiersz składa się z:
* Dowolny **tekst**
* Zmienna kategoryczna (kodowana numerycznie) reprezentująca **zamieszanie**
* Binarna **zmienna leczenia**
* Binarna **zmienna wynikowa**

Następnie system przekaże tekst BERTowi i użyje osadzania BERT + zamieszania do przewidzenia
1) _P(T | C, text)_ 
2) _P(Y | T = 1, C, text)_
3) _P(Y | T = 0, C, text)_
4) Pierwotny cel BERT w zakresie modelowania języka zamaskowanego. 

Po przeszkoleniu powstałe osadzania BERT będą wystarczające do niektórych wniosków przyczynowych. 

Przykład 1

```
df = pd.read_csv('testdata.csv')            
cb = CausalBertWrapper(batch_size=2,                       # zainicjuj opakowanie modelu
    g_weight=0.1, Q_weight=0.1, mlm_weight=1)
cb.train(df['text'], df['C'], df['T'], df['Y'], epochs=1)  # trenować model
print(cb.ATE(df['C'], df['text'], platt_scaling=True))     # użyj modelu, aby uzyskać średni efekt leczenia
```


# Stosowanie


**Zainicjuj** opakowanie modelu (obsługuje szkolenie i wnioskowanie):

```    
cb = CausalBertWrapper(
  batch_size=2,   # 
  g_weight=1.0,   # utrata masy ciała dla głowy przewidywania P(T | C, tekst).
  Q_weight=0.1,   # utrata wagi dla głowic prognozujących P(Y | T, C, tekst).
  mlm_weight=1)   # schudnąć dla pierwotnego celu MLM
```

Następnie **trenuj**
```
cb.train(
  df['text'],    # lista tekstów
  df['C'],       # lista zamieszania
  df['T'],       # lista zabiegów
  df['Y'],       # 0}
  epochs=1)      # 
```

Wykonaj **wnioskowanie**

```
 ( ( P(Y=1|T=1), P(Y=0|T=1)), ( P(Y=1|T=0), P(Y=0|T=0) ), ... =  cb.inference(
  df['text'],    # lista tekstów
  df['C'],       # lista zamieszania

```

Lub oszacuj **średni efekt leczenia**

```
ATE = cb.ATE(
  df['text'],    # lista tekstów
  df['C'],       # lista zamieszania
  platt_scailing=False)    # https://en.wikipedia.org/wiki/Platt_scaling
```


