

# Wnioskowanie i odkrywanie związków przyczynowych w Pythonie

<a href="https://www.packtpub.com/product/causal-inference-and-discovery-in-python/9781804612989"><img src="https://content.packt.com/B18993/cover_image_small.jpg" alt="Causal Inference and Discovery in Python" height="256px" align="right"></a>

To jest repozytorium kodu do książki [Causal Inference and Discovery in Python](https://www.packtpub.com/product/causal-inference-and-discovery-in-python/9781804612989), wydanej przez Packt.

**Odkrywaj sekrety nowoczesnego przyczynowego uczenia maszynowego z wykorzystaniem bibliotek DoWhy, EconML, PyTorch i nie tylko**

## O czym jest ta książka?

Metody przyczynowe w porównaniu z tradycyjnym uczeniem maszynowym i statystyką stanowią unikatowe wyzwanie. Nauka przyczynowości jest trudnym wyzwaniem, ale pokonanie go daje wyraźne korzyści, które wymykają się czysto statystycznemu sposobowi myślenia. Książka „Wnioskowanie przyczynowe i odkrywanie związków przyczynowych w Pythonie” pomaga uwolnić potencjał przyczynowości.

Książka rozpoczyna się od przedstawienia podstawowych motywacji stojących za myśleniem przyczynowym i kompleksowego wprowadzenia do pojęć przyczynowych spopularyzowanych przez Pearla, takich jak strukturalne modele przyczynowe, interwencje, kontrfakty i inne. Każdemu pojęciu towarzyszy teoretyczne wyjaśnienie i zbiór praktycznych ćwiczeń z kodem w Pythonie.

Następnie zagłębisz się w świat szacowania efektów przyczynowych, konsekwentnie zmierzając w kierunku nowoczesnych metod uczenia maszynowego. Krok po kroku odkryjesz ekosystem przyczynowo-skutkowy Pythona i wykorzystasz możliwości najnowocześniejszych algorytmów. Będziesz dalej badać mechanikę tego, jak „przyczyny pozostawiają ślady” i nauczysz się porównywać główne rodziny algorytmów odkrywania przyczyn.


W ostatnim rozdziale przedstawiono szerokie spojrzenie na przyszłość przyczynowej sztucznej inteligencji, w którym przeanalizowano wyzwania i możliwości oraz udostępniono obszerną listę dodatkowych zasobów.

W tej książce omówiono następujące tematy: 
* Podstawowe pojęcia wnioskowania związków przyczynowych.
* Tajniki strukturalnych modeli przyczynowych.
* 4-etapowy procesu wnioskowania przyczynowego w Pythonie
* Zaawansowane techniki modelowania efektu interwencji.
* Sekrety nowoczesnego odkrywania związków przyczynowych za pomocą Pythona.
* Wykorzystanie wnioskowania związków przyczynowych w celu pozytywnego oddziaływania na społeczności.


Jeśli czujesz, że ta książka jest dla Ciebie, pobierz [kopię](https://www.amazon.com/Causal-Inference-Discovery-Python-learning/dp/1804612987/ref=sr_1_1?keywords=Causal+Inference+and+Discovery+in+Python&s=books&sr=1-1) już dzisiaj!



## Instrukcje i nawigacja
Cały kod jest zorganizowany w folderach.

Kod będzie wyglądał następująco:

```
preds = causal_bert.inference(
    texts=df['text'],
    confounds=df['has_photo'],
)[0]
```


**Oto, czego potrzebujesz do tej książki:**

Za najbardziej przydatną uznają tę książkę inżynierowie uczenia maszynowego, badacze danych i uczenia maszynowego, którzy chcą rozszerzyć swój zestaw narzędzi o techniki przyczynowego uczenia maszynowego. Pomoże także programistom zaznajomionym z przyczynowością, którzy pracowali w innej technologii i chcą przejść na Python, oraz badaczom danych z doświadczeniem w pracy z tradycyjną przyczynowością, którzy chcą nauczyć się przyczynowego uczenia maszynowego. Na koniec, z tej książki skorzystają przedsiębiorcy lubiący stosować nowe technologie, którzy chcą zbudować przewagę konkurencyjną dla swoich produktów i wyjść poza ograniczenia tradycyjnego uczenia maszynowego.

Za pomocą poniższej listy oprogramowania i sprzętu możesz uruchomić wszystkie pliki z kodem zawarte w książce (Rozdział 1-15).


### Lista oprogramowania i sprzętu

| Rozdział     | Wymagane oprogramowanie                                                              | Wymagany OS                        |
| --------     | -------------------------------------------------------------------------------------| -----------------------------------|
|  	1-15	   |  Python 3.9                                                                          | Windows macOS, or Linux            |
|  	1-15	   | DoWhy 0.8                                                                            | Windows, macOS, or Linux           |
|  	1-15	   | EconML 0.12.0                                                                        | Windows, macOS, or Linux           |
|  	1-15	   | CATENets 0.2.3                                                                       | Windows, macOS, or Linux           | 
|  	1-15	   | gCastle 1.0.3                                                                        | Windows, macOS, or Linux           |
|  	1-15	   | Causica 0.2.0                                                                        | Windows, macOS, or Linux           |
|  	1-15	   | Causal-learn 0.1.3.3                                                                 | Windows, macOS, or Linux           |
|  	1-15	   | Transformers 4.24.0                                                                  | Windows, macOS, or Linux           |


## Dołącz do naszego serwera Discord <img alt="Coding" height="25" width="32"  src="https://cliply.co/wp-content/uploads/2021/08/372108630_DISCORD_LOGO_400.gif">

Dołącz do naszej społeczności Discord, aby poznać ludzi o podobnych poglądach i uczyć się wraz z ponad 2000 znajomymi na [Discord](https://packt.link/infer) <img alt="Coding" height="15" width="35"  src="https://media.tenor.com/ex_HDD_k5P8AAAAi/habbo-habbohotel.gif">


### Powiązane produkty <Inne książki, które mogą Ci się spodobać>
* Hands-On Graph Neural Networks Using Python  [[Packt]](https://www.packtpub.com/product/hands-on-graph-neural-networks-using-python/9781804617526) [[Amazon]](https://www.amazon.com/Hands-Graph-Neural-Networks-Python/dp/1804617520/ref=sr_1_1?keywords=Hands-On+Graph+Neural+Networks+Using+Python&s=books&sr=1-1)
  
* Applying Math with Python - Second Edition  [[Packt]](https://www.packtpub.com/product/applying-math-with-python-second-edition/9781804618370) [[Amazon]](https://www.amazon.com/Applying-Math-Python-real-world-computational/dp/1804618373/ref=sr_1_1?keywords=Applying+Math+with+Python+-+Second+Edition&s=books&sr=1-1)
  

## Poznaj autora
[**Aleksander Molak**](https://www.linkedin.com/in/aleksandermolak/) jest badaczem i konsultantem zajmującym się uczeniem maszynowym, który zdobył doświadczenie pracując z firmami z listy Fortune 100, Fortune 500 i Inc. 5000 w Europie, USA i Izraelu. W swojej pracy pomagał budować i projektować wielkoskalowe systemy uczenia maszynowego. Aleksander, którego misją jest demokratyzacja przyczynowości dla firm i praktyków uczenia maszynowego, jest płodnym pisarzem, twórcą i międzynarodowym mówcą. Aleksander jest współzałożycielem firmy Lespire.io, innowacyjnego dostawcy szkoleń z zakresu sztucznej inteligencji i uczenia maszynowego dla zespołów korporacyjnych. Jest zaangażowany w prace umożliwiające firmom wykorzystanie pełnego potencjału najnowocześniejszych technologii, co pozwala im wyprzedzić konkurencję.
Jest gospodarzem podcastu poświęconego sztucznej inteligencji [Causal Bandits Podcast](https://causalbanditspodcast.com/).



# Uwagi Autora:

## Instalacja środowiska
1. Zapoznaj się z punktem **Korzystanie z `graphviz` i GPU** poniżej

2. Aby zainstalować środowisko podstawowe, uruchom: `conda env create -f causal_book_py39_cuda117.yml`

3. Aby zainstalować środowisko dla notebooka `Chapter_11.2.ipynb` uruchom: `conda create -f causal-pymc.yml`

## Wybieranie jądra
Po udanej instalacji środowiska otwórz swój notatnik i wybierz jądro `causal_book_py39_cuda117`

Dla notebooka `Chapter_11.2.ipynb` zmień jądro na `causal-pymc`

## Używanie `graphviz` i GPU

**Uwaga**: W zależności od ustawień systemu może zaistnieć potrzeba ręcznej instalacji `graphviz` w celu odtworzenia wykresów w kodzie. 
Instrukcje znajdziesz na https://pypi.org/project/graphviz/ 
specyficzne dla Twojego systemu operacyjnego.

**Uwaga**: Aby korzystać z GPU, musisz zainstalować sterowniki CUDA 11.7.
This can be done here: https://developer.nvidia.com/cuda-11-7-0-download-archive


## Citation

### BibTeX
```{bibtex}
@book{Molak2023,
    title={Causal Inference and Discovery in Python: Unlock the secrets of modern causal machine learning with DoWhy, EconML, PyTorch and more},
    author={Molak, Aleksander},
    publisher={Packt Publishing},
    address={Birmingham},
    edition={1.},
    year={2023},
    isbn={1804612987},
    note={\url{https://amzn.to/3RebWzn}}
}
```

### APA
```
Molak, A. (2023). Causal Inference and Discovery in Python: Unlock the secrets of modern causal machine learning with DoWhy, EconML, PyTorch and more. Packt Publishing.
```

## ‼️Znane błędy // errata
W przypadku znanych błędów i poprawek sprawdź:

* [Books purchased before ~12:00 PM on June 13, 2023](https://github.com/PacktPublishing/Causal-Inference-and-Discovery-in-Python/blob/main/errata/Errata%20-%20Early%20Print%20(ordered%20before%20June%2013%202023).ipynb)

* [Books purchased after ~12:00 PM on June 13, 2023](https://github.com/PacktPublishing/Causal-Inference-and-Discovery-in-Python/blob/main/errata/Errata%20-%20Non-Early%20Print%20(ordered%20after%20June%2013%202023).ipynb)

Jeśli zauważyłeś błąd, daj nam znać na book(at)causalpython.io lub po prostu otwórz **problem** w tym repozytorium.
Dziękuję🙏🏼