﻿Function New-LocalUser
{
  <#
   .Synopsis
    Funkcja tworząca lokalnego użytkownika. 
   .Description
    Funkcja ta tworzy lokalnego użytkownika.
   .Example
    New-LocalUser -userName "ed" -description "świetny skrypciarz" `
        -password "hasło"
    Tworzy nowego użytkownika lokalnego o nazwie ed, opisie świetny skrypciarz
    i z hasłem hasło. 
   .Parameter ComputerName
    Nazwa komputera, na którym ma zostać utworzony użytkownik
   .Parameter UserName
    Nazwa użytkownika, który ma zostać utworzony
   .Parameter password
    Hasło tworzonego użytkownika
   .Parameter description
    Opis utworzonego użytkownika
   .Notes
    NAZWA:  New-LocalUser
    AUTOR: ed wilson, msft
    DATA MODYFIKACJI: 6.9.2013 10:07:42
    SŁOWA KLUCZOWE: zarządzanie lokalnymi kontami, użytkownicy
    HSG: oparte na HSG-06-30-11
    Wymaga uprawnień administratora
   .Link
     Http://www.ScriptingGuys.com/blog
 #>
 [CmdletBinding()]
 Param(
  [Parameter(Position=0,
      Mandatory=$True,
      ValueFromPipeline=$True)]
  [string]$userName,
  [Parameter(Position=1,
      Mandatory=$True,
      ValueFromPipeline=$True)]
  [string]$password,
  [string]$computerName = $env:ComputerName,
  [string]$description = "Utworzone przez PowerShell"
 )
 Write-Debug "Łączenie się z ADSI na komputerze $computerName"
 $computer = [ADSI]"WinNT://$computerName"
 Write-Debug "Wywoływanie metody do utworzenia użytkownika: $userName"
 $user = $computer.Create("User", $userName)
 $user.setpassword($password)
 $user.put("description",$description) 
 Write-Debug "Wywoływanie metody SetInfo"
 $user.SetInfo()
} #end funkcja New-LocalUser