﻿Function Get-Version
{
  <#
   .Synopsis
    Zwraca informacje o systemie operacyjnym lokalnego lub zdalnego komputera 
   .Description
    Funkcja zwracająca informacje o sytemie operacyjnym lokalnego lub zdalnego komputera
   .Example
    Get-Version -computername client1, server1 -credential (Get-Credential iammred\administrator)
    Zwraca informacje o systemie operacyjnym dwóch zdalnych komputerów przy użyciu danych poświadczających podanych przy uruchamiania funkcji
   .Example
    $cred = Get-Credential iammred\administrator
    Get-Version -computername client1, server1, edlt -credential $cred | select caption, version
    Zwraca wartości własności caption i version z dwóch zdalnych komputerów przy użyciu danych poświadczających zapisanych w zmiennej
   .Parameter Computername
    Nazwa komputera docelowego lub komputerów docelowych
   .Parameter Credential
    Dane poświadczające potrzebne do nawiązania połączenia
   .Notes
    NAME:  Get-Version
    AUTHOR: ed wilson, msft
    LASTEDIT: 08/26/2013 13:25:38
    KEYWORDS: CIM, OS
    HSG: 
   .Link
     Http://www.ScriptingGuys.com
 #Requires -Version 2.0
 #>
 Param([string[]]$computername,
 [System.Management.Automation.PSCredential]$credential)
 $cim = New-CimSession @PSBoundParameters
 Get-CimInstance -CimSession $cim -ClassName Win32_OperatingSystem
}