﻿Function Get-WmiClass
{
  <#
   .Synopsis
    Szuka klas WMI 
   .Description
    Funkcja szukająca klas WMI
   .Example
    Get-WmiClass -ns "root\cimv2" -class "Processor"
    Znajduje klasy WMI związane z procesorem
   .Parameter ns
    Przestrzeń nazw
   .Parameter class
    Klasa
   .Notes
    NAME:  Get-WmiClass
    AUTHOR: ed wilson, msft
    LASTEDIT: 08/25/2013 15:45:16
    KEYWORDS: WMI, Scripting Technique
    HSG: 
   .Link
     Http://www.ScriptingGuys.com
 #Requires -Version 2.0
 #>
 Param ([string]$ns, [string]$class)
 Get-WmiObject -List -Namespace $ns |
 Where-Object { $_.name -match $class }
} #end Get-WmiClass
