﻿Function Get-WmiProvider
{
 [cmdletbinding()]
 Param ([string]$providerName)
 $provider =  Get-WmiObject -Class __provider -filter "name = '$providerName'"
 If($provider -ne $null)
   {
    $clsID = $provider.clsID
    Write-Verbose "Znaleziono dostawcę WMI $providerName. Jego CLSID to $($CLSID)"
   }
 Else 
   {
     Return $false
   }
   Write-Verbose "Checking for proper registry registration ..."
   If(Test-Path -path HKCR:)
      {
        Write-Verbose "HKCR: znaleziono dysk. Szukanie $clsID."
        Test-path -path (Join-Path -path HKCR:\CLSID -childpath $CLSID)  
      }
   Else
     {
      Write-Verbose "Nie znaleziono dysku HKCR. Zostanie on utworzony." 
      New-PSDrive -Name HKCR -PSProvider registry -Root HKEY_Classes_Root | Out-Null
      Write-Verbose "Szukanie identyfikatora $clsID"
      Test-path -path (Join-Path -path HKCR:\CLSID -childpath $CLSID)  
      Write-Verbose "Test zakończony."
      Write-Verbose "Usuwanie dysku HKCR." 
      Remove-PSDrive -Name HKCR | Out-Null
     }
} #end funkcja Get-WmiProvider

# *** punkt początkowy skryptu ***
$providerName = "msiprov"

 if(Get-WmiProvider -providerName $providerName  -verbose ) 
  { 
    Get-WmiObject -class win32_product 
  } 
else 
  { 
   "Nie znaleziono dostawcy $providerName." 
  }
