﻿Param (
   [string]$computer = $env:computername, 
   [string]$class, 
   [string]$namespace = "root\cimv2"
) #end param

Function Get-ValidWmiClass([string]$computer, [string]$class, [string]$namespace)
{
 $oldErrorActionPreference = $errorActionPreference
 $errorActionPreference = "SilentlyContinue"
 $Error.Clear()
 [wmiclass]"\\$computer\$($namespace):$class" | out-null
 If($error.count) { Return $false } Else { Return $true }
 $Error.Clear()
 $errorActionPreference =  $oldErrorActionPreference
} # end Get-ValidWmiClass function

Function Get-WmiInformation ([string]$computer, [string]$class, [string]$namespace)
{
  Get-WmiObject -class $class -computername $computer -namespace $namespace|
  Format-List -property [a-z]*
} # end Get-WmiInformation function

# *** punkt początkowy skryptu ***

If(Get-ValidWmiClass -computer $computer -class $class -namespace $namespace) 
  {
    Get-WmiInformation -computer $computer -class $class -namespace $namespace
  }
Else
 {
   "W przestrzeni nazw $namespace na komputerze $computer nie ma klasy o nazwie $class." 
 }