﻿# NAZWA: GetServicesInSvchost.ps1
# AUTOR: ed wilson, Microsoft
# DATA: 21.8.2008
#
# SŁOWA KLUCZOWE: Get-WmiObject, Format-Table, 
# Foreach-Object
#
# UWAGI: Skrypt tworzący tablicę obiektów procesów WMI
# i pobiera uchwyt do każdego z tych obiektów.
# Zgodnie z dokumentacją MSDN, uchwyt jest identyfikatorem
# procesu. Ponadto jest kluczem klasy Win32_Process. Następnie
# skrypt używa uchwytu, który jest tożsamy z własnością processID
# z klasy Win32_service, w celu określenia dopasowań. 
#
# HSG 28.8.2008
# ------------------------------------------------------------------------

$aryPid = @(Get-WmiObject win32_process -Filter "name='svchost.exe'") | 
  Foreach-Object { $_.Handle } 

"Działa " + $arypid.length + " instancji procesu svchost.exe."

foreach ($i in $aryPID) 
{ 
 Write-Host "Usługi działające w ProcessID: $i" ; 
 Get-WmiObject win32_service -Filter " processID = $i" | 
 Format-Table name, state, startMode 
}