﻿# -----------------------------------------------------------------------------
# SKRYPT: CreateFileNameFromDate.ps1
# AUTOR: Ed Wilson, Microsoft
# DATA: 12.15.2008
# SŁOWA KLUCZOWE: platforma .NET, io.path, get-date, plik, new-item, standardowe łańcuchy formatu daty i godziny, wyrażenia regularne, referencje, przekazywanie przez referencję
# UWAGI: Skrypt ten tworzy pusty plik tekstowy na podstawie znacznik czasu. Używa łańcucha formatowania
# w celu określenia sortowalnej daty. Za pomocą metody getInvalidFileNameChars pobiera wszystkie 
# znaki, które nie mogą występować w nazwach plików. Przyjęto założenie, że istnieje folder o nazwie fso na 
# dysku C:\. Jeśli nie ma tego folderu, skrypt nie zadziała.
#
Function GetFileName([ref]$fileName)
{
 $invalidChars = [io.path]::GetInvalidFileNamechars() 
 $date = Get-Date -format s
 $fileName.value = ($date.ToString() -replace "[$invalidChars]","-") + ".txt"
}

$fileName = $null
GetFileName([ref]$fileName)
new-item -path c:\fso -name $filename -itemtype file