﻿# ===========================================================================
# 
# NAZWA: CmdLineArgumentsTime.ps1
# AUTOR: Ed Wilson , microsoft
# DATA  : 19.2.2009
# E-MAIL: Scripter@Microsoft.com
# Wersja: .0
# SŁOWA KLUCZOWE: Add-PSSnapin, powergadgets, Get-Date
# 
# UWAGI: $args[0] to pozbawiony nazwy argument przyjmujący dane z wiersza poleceń.
# C:\cmdLineArgumentsTime.ps1 23 52
# Argumentów nie rozdzielono za pomocą przecinków. Ich użycie spowoduje błąd.
# Wymaga dodatku powergadgets.
# W TOKU: Dodać funkcję pomocniczą do skryptu. 
# ===========================================================================
# W TOKU: zmienić argumenty bez nazw na bardziej przyjazne dla użytkownika.
[int]$inthour = $args[0]
[int]$intMinute = $args[1]
# W TOKU: znaleźć lepszy sposób na sprawdzanie dostępności dodatku powergadgets.
# Obecna metoda powoduje błędy, które można zignorować.
$erroractionpreference = "SilentlyContinue"
# Ta instrukcja kasuje wszystkie błędy i służy do sprawdzania czy są obecne błędy.
$error.clear()
# To polecenie spowoduje błąd, jeśli dodatek PowerGadgets nie będzie zainstalowany.
Get-PSSnapin *powergadgets | Out-Null
# W TOKU: zapytać o zgodę przed załadowaniem dodatku powergadgets.
If ($error.count -ne 0)
{Add-PSSnapin powergadgets} 

New-TimeSpan -Start (get-date) -end (get-date -Hour $inthour -Minute $intMinute) | 
Out-Gauge -Value minutes -Floating -refresh 0:0:30  -mainscale_max 60