﻿# ------------------------------------------------------------------------
# NAZWA: CheckEventLog.ps1
# AUTOR: ed wilson, Microsoft
# DATA: 4.4.2009
#
# SŁOWA KLUCZOWE: Get-EventLog, Param, Function
#
# UWAGI: Skrypt ten przyjmuje dwa parametry: nazwę dziennika
# i liczbę zdarzeń do pobrania. Jeśli dla parametru -max
# nie zostanie podana żadna liczba, skrypt pobierze najnowszy wpis. 
# Jeżeli skrypt zostanie uruchomiony bez uprawnień administratora,
# nie będzie możliwe pobranie danych z dziennika bezpieczeństwa.
# DO ZROBIENIA: Dodać funkcję sprawdzającą, czy skrypt ma uprawnienia
# administracyjne, gdy wybrany zostanie dziennik bezpieczeństwa.
# ------------------------------------------------------------------------
Param($log,$max)
Function Get-log($log,$max)
{
 Get-EventLog -logname $log -newest $max
} #end Get-Log

# DO ZROBIENIA: dokończyć funkcję Get-AdminRights
Function Get-AdminRights
{
# DO ZROBIENIA: Dodać kod sprawdzający posiadanie uprawnień administracyjnych. 
# DO ZROBIENIA: Jeśli skrypt nie działa jako administrator,
#TODO: w miarę możliwości należy dodać kod zdobywający takie uprawnienia.
} #end Get-AdminRights

If(-not $log) { "Podaj nazwę dziennika." ; exit}
if(-not $max) { $max = 1 }
# DO ZROBIENIA: Włączyć test sprawdzający, czy wybrany dziennik jest 
# DO ZROBIENIA: dziennikiem bezpieczeństwa.
# If($log -eq "Security") { Get-AdminRights ; exit }
Get-Log -log $log -max $max