﻿Function Set-ScreenSaverTimeOut
{
 [cmdletbinding()]
 Param( [int]$timeOutValue = 600,
        [string]$path = 'HKCU:\Control Panel\Desktop',
        [string]$name = 'ScreenSaverTimeOut' )
 Write-Verbose "Wywołano funkcję $($MyInvocation.MyCommand.name)"
 Write-Verbose "Aktualna wartość własności $name $((Get-ItemProperty -path $path -name $name).$name)"
 Start-Transaction 
 Set-ItemProperty -Path $path -name $name -value $timeOutValue -UseTransaction 
 Write-Verbose "Nowa wartość własności $name $((Get-ItemProperty -path $path -name $name -UseTransaction).$name)"
 Complete-Transaction
} #end Set-ScreenSaverTimeOut