﻿Param([string[]]$computer = @($env:computername, "LocalHost"))
 foreach ($c in $computer)
  { 
    $o = Get-WmiObject win32_operatingsystem -cn $c
    switch ($o.version)
    {
        {$o.version -gt 6.2} {"$c to Windows 8 lub nowszy"; break}
        {$o.version -gt 6.1} 
          {
           If($o.ServicePackMajorVersion -gt 0){$sp = $true}
           If(Get-WmiObject Win32_Product -cn $c | 
              where { $_.name -match '.NET Framework 4.5'}) {$net = $true }
           If($sp -AND $net) { "$c Spełnia wymagania PowerShell 3" ; break}
           ElseIF (!$sp) {"$c wymaga zainstalowania dodatku Service Pack"; break}
           ELSEIF (!$net) {"$c wymaga aktualizacji platformy .NET Framework"} ; break}
        {$o.version -lt 6.1} {"$c nie spełnia wymagań PowerShell 3.0"; break}
        Default {"Nie wiadomo, czy $c spełnia wymagania PowerShell 3.0"}
    }
  
  }
