###########################################
# Create a bunch of shares
# (C) dr Holger Schwichtenberg, www.IT-Visions.de
###########################################

# Parametry
$Komputer = "."

# Podprocedury

Function New-Share($Komputer, $NazwaUdziau, $cieka, $Komentarz, $Dostp)
{
# Info
"Tworzenie udziau $NazwaUdziau dla cieki $cieka..."

# Usu, jeeli istnieje
Get-WmiObject Win32_Share -ComputerName $Komputer Filter `
  "Name='$NazwaUdziau'" | foreach {
  Write-Warning "Usuwanie istniejcego udziau $($_.Name)..."
  $_.Delete()
}

# Tworzenie obiektu Win32_Share
$Klasa = [WMIClass] "ROOT\CIMV2:Win32_Share" 
$Dostp = $Null
$R = $Klasa.Create($cieka, $NazwaUdziau, 0, 10, $Komentarz, "", $Dostp)

# Wynik
if ( $R.ReturnValue -ne 0) { Write-Error ("Bd przy tworzeniu udziau: " +
$R.ReturnValue); Exit}
"Udzia zosta utworzony!"
}

# Pobieranie pliku XML
$doc = [xml] (Get-Content -Path udziay.xml)
$udziay = $doc.SelectNodes("//Udzia")

# Ptla
foreach ($udzia in $udziay)
{
New-Share $Komputer $udzia.Nazwa $udzia.cieka $udzia.Opis
}
