########################################
# Skrypt PowerShella - inwentaryzacja zainstalowanego oprogramowania 
# wskazanego producenta na n komputerach
# (C) dr Holger Schwichtenberg
########################################

$Producent = "*Microsoft*"
$PlikWejciowy = "komputery.txt" 
$PlikWynikowy = "ListaOprogramowania.csv"

# Importowanie nazw komputerw
$Komputery = Get-Content $PlikWejciowy
$Komputery | foreach { 
#if (Ping($_))
#{
 Write-Host "Inwentaryzowanie oprogramowania komputera $_ ..."
 # Pobieranie listy zainstalowanych pakietw MSI na wszystkich komputerach
 $Oprogramowanie = foreach-object { get-wmiobject win32_product -computername $_ } | 
  where { $_.vendor -like $Producent } 

 # Eksport do CSV
 $Oprogramowanie | export-csv $PlikWynikowy -notypeinformation
#}
#else
#{
# Write-Error "Nie mona nawiza komunikacji z komputerem!"
#}
}

# Wywoania Ping
function Ping
{   
$stan = Get-WmiObject Win32_PingStatus -filter "Address='$args[0]'" | select StatusCode 
return $stan.Statuscode -eq 0
}




