#######################################
# Skrypt PowerShella
# Przeczanie midzy statycznym i dynamicznym IP
# (C) dr Holger Schwichtenberg
# http://www.powershell-doktor.de
########################################

# -- Podprocedury

function PrintStatus
{
$ada = Get-WmiObject Win32_Networkadapter | where { $_.DeviceID -eq $INDEKSADAPTERA }
"Adapter: " + $ada.Caption
"Indeks: " + $INDEKSADAPTERA 
$konfiguracja = Get-WmiObject Win32_Networkadapterconfiguration | where { $_.index -eq $INDEKSADAPTERA }
"Opis: " + $konfiguracja.Description
"IP aktywny: " + $konfiguracja.ipenabled
"DHCP aktywny: " + $konfiguracja.dhcpenabled
"Adresy IP: " + $konfiguracja.IPAddress
#Get-WmiObject Win32_Networkadapterconfiguration | where { $_.index -eq $INDEKSADAPTERA } | select ip
}

# --- ParametrY
$INDEKSADAPTERA = 6
$KOMPUTER = "."
[array] $IP =   "192.168.1.15" 
[array] $PODSIE = "255.255.255.0"
[array] $BRAMY = "192.168.1.16"
[array] $METRYKA = 1

# --- Skrypt
PrintStatus

$konfiguracja = Get-WmiObject Win32_Networkadapterconfiguration | where { $_.index -eq $INDEKSADAPTERA } 

if (!$konfiguracja.dhcpenabled)
{
  "--> Aktywacja DHCP..."
  $konfiguracja.EnableDHCP() | Select-Object returnvalue | format-list
}
else
{
  "--> Aktywacja statycznego adresu IP..."
  $konfiguracja.EnableStatic($ip, $PODSIE) | Select-Object returnvalue | format-list
  $konfiguracja.SetGateways($BRAMY, $METRYKA) | Select-Object returnvalue | format-list
}

PrintStatus