#######################################
# Skrypt PowerShella
# (C) dr Holger Schwichtenberg
# http://www.powershell-doktor.de
########################################



# Wywietlanie listy dziennikw zdarze, ich konfiguracji i rozmiarw
Get-EventLog list

#Lista zdarze czyli obiektw System.Diagnostics.EventLog
Get-EventLog Application 

#Lista 30 ostatnich zdarze
Get-EventLog Application -newest 30

#Pomocnicza funkcja uatwiajca filtrowanie

function jestDzisiaj ([datetime]$data) 	
{[datetime]::Now.Date  -eq  $data.Date}	

Get-EventLog Application -newest 2048 |where {jestDzisiaj $_.TimeWritten}

#Funkcja, ktra pozwala sprawdzi czy zdarzenie pochodzi z ostatnich kilku dni

function nieStarszeNi([int]$dni, [datetime]$Data)
{
    [DateTime]::Now.AddDays($dni).Date -le $Data.Date
}

Get-EventLog Application |where {isWithin -3 $_.TimeWritten}

# Mona te wyszuka najczciej wystpujce zdarzenia:
Get-EventLog Application | Group-Object eventid | Sort-Object Count
