﻿###########################################
## Directory Access withe the
## www.IT-Visions.de PowerShell Commandlets
## dr Holger Schwichtenberg 2007
###########################################

# Parameter
$Name = "HolgerSchwichtenberg"
$Komputer = "E01"
$Container = "WinNT://$Komputer"

Write-Host Access to the Container" -ForegroundColor yellow
Get-DirectoryEntry ($Container) | select name
# Alternative: Get-DirectoryEntry "WinNT://$Komputer" | select name

Write-Host "Create User" -ForegroundColor yellow
$u = Add-User  -RDN $Name -Container $Container -Password "sdd%24343423"

Write-Host "Set attributes - Commandlet Style" -ForegroundColor yellow
Set-DirectoryValue -Path ($Container +"/" + $Name) -Name "Description" -Value "Author of this book"

Write-Host "Set attributes - Object Style" -ForegroundColor yellow
$u.Fullname = "dr Holger Schwichtenberg"
$u.PSBase.CommitChanges()
# Alternative: Set-DirectoryValue -Path ("WinNT://" + $Komputer +"/" + $Name) -Name "Fullname" -Value "dr Holger Schwichtenberg"

Write-Host "Reading user - Object style" -ForegroundColor yellow
$u = Get-DirectoryEntry ($Container +"/" + $Name)
"Name: " + $u.Fullname

Write-Host "Reading user - Commandlet style" -ForegroundColor yellow
get-DirectoryValue -Path ($Container +"/" + $Name) -Name "Fullname" 

Write-Host "Remove User" -ForegroundColor yellow
Remove-DirectoryEntry ($Container + "/" + $Name)

Write-Host "List of all elements in the container" -ForegroundColor yellow
Get-DirectoryChildren $Container | select name
