#######################################
# Skrypt PowerShella
# (C) dr Holger Schwichtenberg
# http://www.powershell-doktor.de
########################################

$Root = new-object system.directoryservices.directoryEntry("LDAP://Serwer1/DC=dtest,DC=windowsservernet,DC=com")
#$Root = new-object system.directoryservices.directoryEntry("LDAP://E01")

#$Filter = "(&(objectclass=user)(|(telephonenumber=*7490*)(otherTelephone=*7490*)))"
$Filter = "(&(objectCategory=person)(objectclass=user)(|(telephonenumber=*7490*)(otherTelephone=*7490*)))"
#$Filter = "(&(objectCategory=group)(objectclass=group)(grouptype=-2147483646))"
$Filter = "(&(objectclass=user)(name=h*))"

$Attribute = "CN","ObjectClass","ObjectCategory","distinguishedName","lastLogonTimestamp","description","department","displayname"

# Przygotowywanie wyszukiwania
$Searcher = New-Object Directoryservices.DirectorySearcher($Root)
$searcher.PageSize = 900 
$searcher.Filter = $Filter
$searcher.Searchscope = [System.DirectoryServices.SearchScope]::Subtree
$Attribute | foreach {[void]$searcher.PropertiesToLoad.Add($_)} 
# Uruchamianie wyszukiwania
$wynik = $searcher.findAll()
"Liczba znalezionych wpisw: " + $wynik.Count
$wynik 
