﻿###########################################
## Operacje katalogowe - przykłady
## www.IT-Visions.de PowerShell Commandlets
## dr Holger Schwichtenberg 2007
###########################################

# --- Parametry
 
$Nazwa = "cn=FoxMulder"
$Kontener = "LDAP://Serwer1/OU=Agenci,DC=dtest,DC=windowsservernet,DC=com"

# --- Zapis

Write-Host "Dostęp do kontenera" -ForegroundColor yellow
Get-DirectoryEntry $Kontener | select name

Write-Host "Tworzenie użytkownika" -ForegroundColor yellow
$u = Add-User -Name $Nazwa -Container $Kontener -Password "seKret-123" -verbose

Write-Host "Ustawianie atrybutu - styl apletów poleceń" -ForegroundColor yellow
Set-DirectoryValue -Path $u.psbase.path -Name "Description" -Value "Agent"

Write-Host "Ustawianie atrybutu - styl obiektowy" -ForegroundColor yellow
$u.l = "Washington DC"

$u.PSBase.CommitChanges()

# --- Odczyt

Write-Host "Odczyt atrybutu - styl obiektowy" -ForegroundColor yellow
$u = Get-DirectoryEntry $u.psbase.path 
"Opis: " + $u.Description

Write-Host "Odczyt atrybutu - styl apletów poleceń" -ForegroundColor yellow
get-DirectoryValue -Path $u.psbase.path  -Name "Description" 

Write-Host "Usuwanie użytkownika" -ForegroundColor yellow
Remove-DirectoryEntry $u.psbase.path 

Write-Host "Lista zawartości kontenera" -ForegroundColor yellow
Get-DirectoryChildren $Kontener | select name


