# ---------------------------------------------------------------------------
# Author: Keith Hill, jachymko
# Desc:   Simple global profile to get you going with PowerShell.
# Date:   Nov 18, 2006
# Site:   http://www.codeplex.com/PowerShellCX
# Usage:  Copy this file to your WindowsPowerShell directory e.g.:
#
#  Copy-Item "$Env:PscxHome\Profile\Profile.ps1" (Split-Path $Profile -Parent)
#
# ---------------------------------------------------------------------------
# Adapted by Holger Schwichtenberg, July 2007

# ---------------------------------------------------------------------------
# Configure standard PowerShell variables to more useful settings
# ---------------------------------------------------------------------------
$MaximumHistoryCount = 512
$FormatEnumerationLimit = 100

# ---------------------------------------------------------------------------
# PowerShell Community Extensions preference variables. Comment/uncomment
# or change to suit your preference.
# ---------------------------------------------------------------------------
$PscxTextEditorPreference = "Notepad"

# ---------------------------------------------------------------------------
# Dirx/dirs/dirt/dird/dirw functions will specifies -Force with the value of
# the following preference variable.  Set to $true will cause normally hidden 
# items to be returned.
# ---------------------------------------------------------------------------
$PscxDirForcePreference = $true

# ---------------------------------------------------------------------------
# Dirx/dirs/dirt/dird/dirw functions will filter out files with the system 
# attribute set if the following preference variable is set to $true. 
# However the performance may suffer on high latency networks or in folders
# with many files.
# ---------------------------------------------------------------------------
##$PscxDirHideSystemPreference = $false

# ---------------------------------------------------------------------------
# Display file sizes in KB, MB, GB multiples.
# ---------------------------------------------------------------------------
$PscxFileSizeInUnitsPreference = $false

# ---------------------------------------------------------------------------
# The Send-SmtpMail default settings.
# ---------------------------------------------------------------------------
## $PscxSmtpFromPreference = 'john_doe@example.net'
## $PscxSmtpHostPreference = 'smtp.example.net'
## $PscxSmtpPortPreference = 25

# ---------------------------------------------------------------------------
# Uncomment this to create a transcript of the entire PowerShell session.
# ---------------------------------------------------------------------------
## $PscxTranscribeSessionPreference = $true

# ---------------------------------------------------------------------------
# You can modify every aspect of the PSCX prompt appearance by 
# creating your own eye-candy script.
# ---------------------------------------------------------------------------
## $PscxEyeCandyScriptPreference = '.\EyeCandy.Jachym.ps1'
$PscxEyeCandyScriptPreference = '.\EyeCandy.Keith.ps1'

# ---------------------------------------------------------------------------
# The following functions are used during processing of the PSCX profile
# and are deleted at the end of loading this profile.  
# !! Do not modify or remove the functions below !!
# ---------------------------------------------------------------------------
function Set-PscxVariable($name, $value) {
    Set-Variable $name $value -Scope Global -Option AllScope,ReadOnly -Description "PSCX variable"
}

function Set-PscxAlias($name, $value, $type = 'cmdlet', [switch]$force) {
    Set-Alias $name $value -Scope Global -Option AllScope -Force:$force -Description "PSCX $type alias"
}

function Test-PscxPreference($name) {
    if (Test-Path "Variable:$name") {
        (Get-Variable $name).Value
    }
    else {
        $false
    }
}
# ---------------------------------------------------------------------------
# !! Do not modify or remove the functions above !!
# ---------------------------------------------------------------------------

if (!(Test-Path Variable:__PscxProfileRanOnce)) { 
    # ---------------------------------------------------------------------------
    # This should only be run once per PowerShell session
    # ---------------------------------------------------------------------------
    Add-PSSnapin Pscx
    Start-TabExpansion
    
    # ---------------------------------------------------------------------------
    # Load ps1xml files which override built-in PowerShell defaults.
    # ---------------------------------------------------------------------------
        Update-FormatData -PrependPath "$Env:PscxHome\FormatData\FileSystem.ps1xml"
        Update-FormatData -PrependPath "$Env:PscxHome\FormatData\Reflection.ps1xml"
    
    # ---------------------------------------------------------------------------
    # Create $UserProfile to point to the user's non-host specific profile script
    # ---------------------------------------------------------------------------
    Set-PscxVariable ProfileDir  (split-path $MyInvocation.MyCommand.Path -Parent)
    Set-PscxVariable UserProfile (join-path $ProfileDir 'Profile.ps1')
    
    # ---------------------------------------------------------------------------
    # Create PSCX convenience variables, identity variables used by EyeCandy.*.ps1
    # ---------------------------------------------------------------------------
    Set-PscxVariable PscxHome    ($env:PscxHome)
    Set-PscxVariable PscxVersion ([Version](Get-FileVersionInfo (Get-PSSnapin Pscx).ModuleName).ProductVersion)
    Set-PscxVariable Shell       (new-object -com Shell.Application)
    Set-PscxVariable NTIdentity  ([Security.Principal.WindowsIdentity]::GetCurrent())
    Set-PscxVariable NTAccount   ($NTIdentity.User.Translate([Security.Principal.NTAccount]))
    Set-PscxVariable NTPrincipal (new-object Security.Principal.WindowsPrincipal $NTIdentity)
    Set-PscxVariable IsAdmin ($NTPrincipal.IsInRole([Security.Principal.WindowsBuiltInRole]::Administrator))    
}
else {
    # ---------------------------------------------------------------------------
    # This should be run every time you want apply changes to your type and format 
    # files.
    # ---------------------------------------------------------------------------
    Update-FormatData
    Update-TypeData
}

# ---------------------------------------------------------------------------
# PowerShell Community Extensions utility functions and filters.
# Comment out or remove any dot sourced functionality that you don't want.
# ---------------------------------------------------------------------------    
Push-Location (Join-Path $Env:PscxHome 'Profile')
. '.\TabExpansion.ps1'
. '.\GenericAliases.ps1'
. '.\GenericFilters.ps1'
. '.\GenericFunctions.ps1'
. '.\PscxAliases.ps1'
. '.\Debug.ps1'
. '.\Environment.VirtualServer.ps1'
#. '.\Environment.VisualStudio2005.ps1'
. '.\Cd.ps1'
. '.\Dir.ps1'
. '.\TranscribeSession.ps1'
. $PscxEyeCandyScriptPreference
Pop-Location

# ---------------------------------------------------------------------------
# Add PSCX Scripts dir to Path environment variable to allow scripts to be executed.
# ---------------------------------------------------------------------------
Add-PathVariable Path $env:PscxHome,$env:PscxHome\Scripts    

# ---------------------------------------------------------------------------
# Remove functions only required for the processing of the PSCX profile.
# ---------------------------------------------------------------------------
Remove-Item Function:Set-PscxAlias
Remove-Item Function:Set-PscxVariable

# ---------------------------------------------------------------------------
# Keep track of whether or not this profile has ran already and remove the
# temporary functions
# ---------------------------------------------------------------------------
Set-Variable __PscxProfileRanOnce

# ---------------------------------------------------------------------------
# Additions from dr Holger Schwichtenberg
# ---------------------------------------------------------------------------

# Loading Snap-Ins
Add-PSSnapin ITVisions_PowerShell_Extensions

# Title
$WI = [System.Security.Principal.WindowsIdentity]::GetCurrent()
$WP = New-Object System.Security.Principal.WindowsPrincipal($wi)
if ($WP.IsInRole([System.Security.Principal.WindowsBuiltInRole]::Administrator))
{
    $Status = "[uprawnienia administratora]"
}
else
{
    $Status = "[uprawnienia uytkownika]"
}
#$PscxWindowTitlePrefix = "PowerShell - " + [System.Environment]::UserName  + " " + $Status + " - "


$Host.UI.RawUI.WindowTitle = "PowerShell - " + `
[System.Environment]::UserName + " " + $Status
