#######################################
# Skrypt PowerShella
# (C) dr Holger Schwichtenberg
########################################

# Zmiana ACL: Usuwanie wpisw kontroli dostpu przyznajcych prawo odczytu i zapisu("ReadAndExecute") 
# Parametry
$KATALOG = "h:\projekty"
$UYTKOWNIK = "itv\HS"
$Licznik = 0

# Dane pocztkowe
$acl = Get-Acl  $KATALOG
"Lista ACL przed:"
$acl | format-list

# Pobieranie ACL 
$acl = Get-Acl h:\projekty 

# Pobieranie wpisw ACE
$aces =$acl.GetAccessRules($true, $true, [System.Security.Principal.NTAccount])

# Iterowanie ACE
foreach ($ace in $aces)
{
Write-host $ace.IdentityReference.ToString() " - " $ACE.FileSystemRights $ACE.AccessControlType " odziedziczone?"  $ACE.IsInherited 
# Selektywne usuwanie
if ($ace.FileSystemRights.ToString() -match "ReadAndExecute") 
 {
  "...usuwanie..."
  $Wynik = $acl.RemoveAccessRule($ace)
if ($Wynik) { echo "Wpis ACE usunity!"; $Licznik++ }
 }
}

# Zapisywanie ACL 
set-acl -AclObject $ACL -Path $KATALOG

echo ($Licznik.ToString() + " wpisw ACE usunito!")

# Dane kocowe
$acl = Get-Acl  $KATALOG
"Lista ACL po:"
$acl | format-list
