# =====================
# Skrypt IIS: Tworzenie witryn
# (C) dr Holger Schwichtenberg
# =====================

# === Pobierz obiekt WMI z szyfrowaniem DCOM
Function Get-WMIObjectEx($ObszarNazw, $cieka)
{
#Write-Host $ObszarNazw $cieka
$poczenie = New-Object System.Management.ConnectionOptions
$poczenie.Authentication = [System.Management.AuthenticationLevel]::PacketPrivacy
$zakres = New-Object System.Management.ManagementScope($ObszarNazw, $poczenie)
$cieka = New-Object System.Management.ManagementPath($cieka)
$GetOptions = New-Object System.Management.ObjectGetOptions
$WMI = New-Object System.Management.ManagementObject($zakres,$cieka,$GetOptions)
return $WMI
}

# === Pobierz klas WMI z szyfrowaniem DCOM
Function Get-WMIClassEx($ObszarNazw, $cieka)
{
Write-Host $ObszarNazw $cieka
$poczenie = New-Object System.Management.ConnectionOptions
$poczenie.Authentication = [System.Management.AuthenticationLevel]::PacketPrivacy
$zakres = New-Object System.Management.ManagementScope($ObszarNazw, $poczenie)
$cieka = New-Object System.Management.ManagementPath($cieka)
$GetOptions = New-Object System.Management.ObjectGetOptions
return New-Object System.Management.ManagementClass($zakres,$cieka,$GetOptions)
}

# === Tworzenie witryny
function New-IISVirtWeb ([string]$Komputer, [string]$Nazwa, [string]$IP, [string]$Port, [string]$NazwaStacji, [string]$KatalogGwny) 
{
$ObszarNazw = "\\"  + $Komputer + "\root\MicrosoftIISv2"
$cieka1 = $ObszarNazw + ":ServerBinding"
$cieka2 = $ObszarNazw + ":IIsWebService='W3SVC'"


# Tworzenie powizania
$klasa = Get-WMIClassEx $ObszarNazw $cieka1
$powizanie = $klasa.CreateInstance()
$powizanie.IP = $IP
$powizanie.Port = $Port 
$powizanie.Hostname = $NazwaStacji
[array] $powizania = $powizanie

# Tworzenie witryny
$UsugaWWW = Get-WMIObjectEx $ObszarNazw  $cieka2
$Witryna = $UsugaWWW.CreateNewSite($Nazwa, $powizania, $KatalogGwny) 

Write-Host "Serwer" $Nazwa "utworzony na komputerze" $Komputer "!"
}


# --- Parametry
$Plik wejciowy = "c:\demo\WPS\B_IIS\serweryWWW.txt"
$Komputer = "E01"

# Odczytywanie pliku tekstowego i tworzenie serwerw
Get-Content $InputFile | Foreach-Object {
$a = $_.Split(";")
New-IISVirtWeb $Komputer  $a[0]  $a[1] $a[2] "" $a[3] 
}
