#######################################
# Skrypt PowerShella
# (C) dr Holger Schwichtenberg
# http://www.powershell-doktor.de
########################################

# Wymagania: www.IT-Visions.de Commandlet Extension Library
# http://www.powershell-doktor.de

# Parametry
$SQL = "Select * from konta order by nazwisko"
$Poczenie = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=c:\demo\WPS\B_BazyDanych\BazaKont.mdb;"
$Dostawca = "b"

"----------Testowanie poczenia z baz danych:"
test-dbconnection -connection $Poczenie   -provider $Dostawca 

"---------- Wykonywanie instrukcji SQL:"

$SQL1 = "Select count(*) from konta"
$SQL2 = "insert into konta ( imi, nazwisko) values ('Jan', 'Kowalski')"
$SQL3 = "delete from konta where nazwisko='Kowalski'"

invoke-ScalarDbCommand -connection $Poczenie   -sql $SQL1 -provider $Dostawca 
invoke-DbCommand -connection $Poczenie   -sql $SQL2 -provider $Dostawca 
invoke-ScalarDbCommand -connection $Poczenie   -sql $SQL1 -provider $Dostawca 
invoke-DbCommand -connection $Poczenie   -sql $SQL3 -provider $Dostawca 
invoke-ScalarDbCommand -connection $Poczenie   -sql $SQL1 -provider $Dostawca 

"---------- Pobieranie danych "
$tabela = Get-DbTable -connection $Poczenie   -sql $SQL -provider  $Dostawca  
$tabela | ft

"---------- Wybieranie wiersza "
$wiersz = $tabela | where  { $_.nazwisko -eq "Anders" }
$wiersz

"---------- Zmiana wiersza "
$wiersz.kontener = "WinNT://Osoby"
$wiersz

"---------- Aktualizacja danych "
$tabela | Set-DbTable -connection $Poczenie -sql $sql -provider  $Dostawca  -verbose

"---------- Pobieranie wiersza"
$SQL = "Select * from konta where nazwisko = 'Anders'"
$wiersz = Get-DbRow $Poczenie $SQL $Dostawca
$wiersz
