#######################################
# Skrypt PowerShella
# Wywietla czonkw grupy, przypisanych bezporednio i porednio
# (C) dr Holger Schwichtenberg
# http://www.powershell-doktor.de
########################################

#(new-object  directoryservices.directoryentry("LDAP://serwer1/CN=Wszyscy pracownicy FBI,DC=FBI,DC=net")).member

"Bezporedni czonkowie grupy:"
$grupa = New-Object directoryservices.directoryentry("LDAP://serwer1/CN=Wszyscy pracownicy,DC=dtest,DC=windowsservernet,DC=com")
$grupa.member

function Get-Members ($grupa){
  if ($grupa.objectclass[1] -eq 'group') { 
   "-- Grupa $($grupa.cn)" 
    $grupa.member | foreach-object { 
      $de = new-object directoryservices.directoryentry("LDAP://serwer1/" + $_) 
      if ($de.objectclass[1] -eq 'group') { 
        Get-Members $de 
      } 
      Else { 
        $de.distinguishedName 
      } 
    } 
  }
  Else {
    Throw "$grupa nie jest grup."
  } 
} 

"--- Lista czonkw grupy:"
"Wszyscy czonkowie (cznie z nie bezporednimi):"
Get-Members(new-object directoryservices.directoryentry("LDAP://serwer1/CN=Wszyscy pracownicy,DC=dtest,DC=windowsservernet,DC=com"))
