﻿using System;
using System.Windows;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Controls.Maps;
using System.Device.Location;
using Microsoft.Phone.Controls.Maps.Platform;

namespace BingMapDemo
{
    public partial class MainPage : PhoneApplicationPage
    {
        GeoCoordinateWatcher _geoCoordinateWatcher; 

        public MainPage()
        {
            InitializeComponent();
            // Tutaj należy zapisać uzyskany klucz serwisu BingMap
            bingMap.CredentialsProvider = new ApplicationIdCredentialsProvider("AlWWYPw-HBVuA3AvU5AKn0cbGNp7jqjX0Vk5KFCIUHGgJRSktD0PRomkCnDPntPB");
            
            // Usunięcie logo Bing Map i informacji o prawa autorskich 
            // w celu uzyskania dodatkowej przestrzeni w dolnej części ekranu
            bingMap.LogoVisibility = Visibility.Collapsed;
            bingMap.CopyrightVisibility = Visibility.Collapsed;

            // Powołanie obiektu GeoCoordinateWatchero dużej dokładności pomiaru
            // (wykorzystanie odbiornika GPS)
            _geoCoordinateWatcher = new GeoCoordinateWatcher(GeoPositionAccuracy.High);
            _geoCoordinateWatcher.MovementThreshold = 100;

            // Subskrypcja zdarzenia zmiany statusu
            _geoCoordinateWatcher.StatusChanged += 
                new EventHandler<GeoPositionStatusChangedEventArgs>(_geoCoordinateWatcher_StatusChanged);

            // Subskrypcja zdarzenia zmiany pozycji -
            // przekazywane parametry to współrzędnej GPS (długość i szerokość)
            _geoCoordinateWatcher.PositionChanged += 
                new EventHandler<GeoPositionChangedEventArgs<GeoCoordinate>>(_geoCoordinateWatcher_PositionChanged);
        }

        private void _geoCoordinateWatcher_PositionChanged(object sender, GeoPositionChangedEventArgs<GeoCoordinate> e)
        {
            Deployment.Current.Dispatcher.BeginInvoke(() => ChangePosition(e)); 
        }

        private void ChangePosition(GeoPositionChangedEventArgs<GeoCoordinate> e)
        {
            SetLocation(e.Position.Location.Latitude, e.Position.Location.Longitude, 10, true);
        }

        private void _geoCoordinateWatcher_StatusChanged(object sender, GeoPositionStatusChangedEventArgs e)
        {
            Deployment.Current.Dispatcher.BeginInvoke(() => StatusChanged(e)); 
        }

        private void btnStart_Click(object sender, RoutedEventArgs e)
        {
            // sprawdzenie, czy usług pozycjonowania może zostać uruchomiona
            if (!_geoCoordinateWatcher.TryStart(true, TimeSpan.FromSeconds(5)))
            {
                MessageBox.Show("Włącz usługę pozycjonowania w telefonie.", "Uwaga", MessageBoxButton.OK);
            }
        }

        private void StatusChanged(GeoPositionStatusChangedEventArgs e)
        {
            switch (e.Status)
            {
                case GeoPositionStatus.Disabled:
                    txtStatus.Text = "Usługa pozycjonowania jest wyłączona!";
                    break;
                case GeoPositionStatus.Initializing:
                    txtStatus.Text = "Włączanie usługi pozycjonowania...";
                    break;
                case GeoPositionStatus.NoData:
                    txtStatus.Text = "Nie można ustalić bieżącej pozycji.";
                    SetLocation(0, 0, 10, false);
                    break;
                case GeoPositionStatus.Ready:
                    break;
            }
        }

        private void SetLocation(double latitude, double longitude, double zoomLevel, bool showLocator)
        {
            Location location = new Location();
            location.Latitude = latitude;
            location.Longitude = longitude;
            bingMap.SetView(location, zoomLevel);
            bingMapLocator.Location = location;
            if (showLocator)
            {
                locator.Visibility = Visibility.Visible;
                BlinkLocator.Begin();
            }
            else
            { 
                locator.Visibility = Visibility.Collapsed;
                BlinkLocator.Stop();
            }
        }
    }
}
