﻿using System.Windows;
using Microsoft.Phone.Controls;
using AddressPlottingDemo.BingMapGeoCodeService;
using System.Collections.ObjectModel;
using Microsoft.Phone.Controls.Maps;
using System.Linq;

namespace AddressPlottingDemo
{
    public partial class MainPage : PhoneApplicationPage
    {
        GeocodeServiceClient _svc;
        public MainPage()
        {
            InitializeComponent();

            // Powołanie obiektu usługi Bing Map GeocodeService
            _svc = new GeocodeServiceClient();
            _svc.GeocodeCompleted += (s, e) =>
                 {
                     // Posortowanie wyników względem trafności - najlepszy rezultat
                     // jest pierwszy. Wartości numeryczne to: 0 - wysoko zgodność,
                     // 1 - średnia, 2 - niska.
                     var geoResult = (from r in e.Result.Results 
                                      orderby (int)r.Confidence ascending 
                                      select r).FirstOrDefault();
                     if (geoResult != null)
                     {
                         this.SetLocation(geoResult.Locations[0].Latitude,
                             geoResult.Locations[0].Longitude,
                             10,
                             true);
                     }
                 };
        }

        private void SetLocation(double latitude, double longitude, double zoomLevel, bool showLocator)
        {
            // Przesunięcie znacznika na pozycję odpowiadającą współrzędnym geograficznym
            Microsoft.Phone.Controls.Maps.Platform.Location location = new Microsoft.Phone.Controls.Maps.Platform.Location();
            location.Latitude = latitude;
            location.Longitude = longitude;
            bingMap.SetView(location, zoomLevel);
            bingMapLocator.Location = location;
            if (showLocator)
            {
                locator.Visibility = Visibility.Visible;
            }
            else
            { 
                locator.Visibility = Visibility.Collapsed;
            }
        }

        private void btnPlot_Click(object sender, RoutedEventArgs e)
        {
            BingMapGeoCodeService.GeocodeRequest request = new BingMapGeoCodeService.GeocodeRequest();

            // Uwzględnienie tylko trafień o wysokim poziomie zgodności.
            request.Options = new GeocodeOptions()
            {
                Filters = new ObservableCollection<FilterBase>
                {
                    new ConfidenceFilter()
                    {
                        MinimumConfidence = Confidence.High
                    }
                }
            };


            request.Credentials = new Credentials()
            {
                ApplicationId = "AlWWYPw-HBVuA3AvU5AKn0cbGNp7jqjX0Vk5KFCIUHGgJRSktD0PRomkCnDPntPB"
            };

            request.Query = txtAddress.Text;
            
            // Asynchroniczne pobranie współrzędnych geograficznych
            _svc.GeocodeAsync(request);
        }
    }
}