﻿using System.Windows;
using Microsoft.Phone.Controls;
using Microsoft.Devices.Sensors;

namespace CatchingDeviceExceptionsDemo
{
    public partial class MainPage : PhoneApplicationPage
    {
        Accelerometer _acc;

        public MainPage()
        {
            InitializeComponent();
            _acc = new Accelerometer();
        }

        private void btnStartAcc_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                _acc.Start();

                _acc.ReadingChanged += (s1, e1) =>
                    {
                        // Przetwarzanie danych akcelerometru
                    };
            }
            catch (AccelerometerFailedException ex)
            {
                string errorMessage = string.Format(@"
                            Podczas włączania akcelerometru wystąpił błąd o identyfikatorze {0}
                            Przyczyna problemu: {1}
                            ", ex.ErrorId, ex.Message);
                MessageBox.Show(errorMessage);
            }
        }

        private void btnStopAcc_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                 _acc.Stop();
            }
            catch (AccelerometerFailedException ex)
            {
                string errorMessage = string.Format(@"                       
                            Podczas wyłączania akcelerometru wystąpił błąd o identyfikatorze {0}
                            Przyczyyna problemu: {1}
                            ", ex.ErrorId, ex.Message);
                MessageBox.Show(errorMessage);
            }
        }
    }
}