﻿using System.Windows;
using System.Windows.Controls;
using Microsoft.Phone.Controls;
using System.IO.IsolatedStorage;
using System.IO;

namespace IsolatedStorageDemo
{
    public partial class MainPage : PhoneApplicationPage
    {
        IsolatedStorageFile _isf;
        public MainPage()
        {
            InitializeComponent();

            // Set the orientation to only support Portraitof th
            SupportedOrientations = SupportedPageOrientation.Portrait;

            InitializeApp();
        }

        private void InitializeApp()
        {
            // Get application specific isolated storage
            _isf = IsolatedStorageFile.GetUserStoreForApplication();

            // Get user quota of isolated storage
            lblAvailableSpace.Text = (_isf.AvailableFreeSpace / 1024 / 1024).ToString() + "MB";
            
            // Create three directories.
            _isf.CreateDirectory("MyDirectory1");
            _isf.CreateDirectory("MyDirectory2");
            _isf.CreateDirectory("MyDirectory3");

            // Add files to the directories
            AddFiles("MyDirectory1", "File01_InMyDirectory1.txt");
            AddFiles("MyDirectory2", "File01_InMyDirectory2.txt");
            AddFiles("MyDirectory3", "File01_InMyDirectory3.txt");

            // Bind directory list to the lstDirectory LisBox
            lstDirectory.ItemsSource = _isf.GetDirectoryNames();

            // Bind root file list to the lstFiles LisBox
            lstFiles.ItemsSource = _isf.GetFileNames("*.*");

            // Select the first item in the directory list
            //lstFiles.SelectedIndex = 0;
        }

        private void AddFiles(string directoryNamePath, string fileName)
        {
            using (IsolatedStorageFileStream myDirectory1File =
               _isf.CreateFile(Path.Combine(directoryNamePath, fileName)))
            {
                using (StreamWriter writeToMyDirectory1 = new StreamWriter(myDirectory1File))
                {
                    writeToMyDirectory1.WriteLine(string.Format("This is a file, {0} in {1}!", 
                                                        fileName, directoryNamePath));
                }
            }
        }

        private void lstDirectory_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            // Build directory file search pattern
            string fileSearchPattern = Path.Combine(e.AddedItems[0].ToString(), "*.*");

            // Bind root file list of selected directory to the lstFiles LisBox
            lstFiles.ItemsSource = _isf.GetFileNames(fileSearchPattern);

            // Set file content blank
            txtFileContent.Text = "";
        }

        private void lstFiles_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            if (e.AddedItems.Count > 0)
            {
                // Build fule file path using selected directory and selected file
                string file = string.Empty;
                if (lstDirectory.SelectedIndex < 0)
                {
                    file = e.AddedItems[0].ToString();
                }
                else
                {
                    file = Path.Combine(lstDirectory.SelectedItem.ToString(),
                                                e.AddedItems[0].ToString());
                }
                // Extract selected file content
                using (IsolatedStorageFileStream fileStream =
                    new IsolatedStorageFileStream(file, FileMode.Open, _isf))
                {
                    using (StreamReader fileReader = new StreamReader(fileStream))
                    {
                        txtFileContent.Text = fileReader.ReadToEnd();
                    }
                }
            }
        }

        private void btnDelete_Click(object sender, RoutedEventArgs e)
        {
            if (lstFiles.SelectedIndex > -1)
            {
                // Delete selected file from the directory
                string file = Path.Combine(lstDirectory.SelectedItem.ToString(),
                                            lstFiles.SelectedItem.ToString());
                _isf.DeleteFile(file);

                // Build directory file search pattern
                string fileSearchPattern = Path.Combine(lstDirectory.SelectedItem.ToString()
                                            , "*.*");

                // Bind root file list of selected directory to the lstFiles LisBox
                lstFiles.ItemsSource = _isf.GetFileNames(fileSearchPattern);

                // Set file content blank
                txtFileContent.Text = "";
            }
        }

        private void btnSave_Click(object sender, RoutedEventArgs e)
        {
            if (lstFiles.SelectedIndex > -1)
            {
                string directoryPath = lstDirectory.SelectedItem.ToString();
                string fileName = lstFiles.SelectedItem.ToString();

                // Delete selected file from the directory
                string file = Path.Combine(directoryPath, fileName);
                using (IsolatedStorageFileStream myDirectory1File = _isf.CreateFile(file))
                {
                    using (StreamWriter writeToMyDirectory1 = new StreamWriter(myDirectory1File))
                    {
                        writeToMyDirectory1.WriteLine(txtFileContent.Text);
                    }
                }
            }
        }

        private void btnRemoveAll_Click(object sender, RoutedEventArgs e)
        {
            // remove all directories and files
            _isf.Remove();

            // Bind directory list to the lstDirectory LisBox
            lstDirectory.ItemsSource = null;

            // Bind root file list to the lstFiles LisBox
            lstFiles.ItemsSource = null;
        }
    }
}