﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Tasks;
using System.Diagnostics;
using System.IO.IsolatedStorage;
using System.IO;
using System.Threading;

namespace Tasks
{
    public partial class MainPage : PhoneApplicationPage
    {
        private PhoneNumberChooserTask _choosePhoneNumberTask; 

        public MainPage()
        {
            InitializeComponent();

            _choosePhoneNumberTask = new PhoneNumberChooserTask();
            _choosePhoneNumberTask.Completed += new EventHandler<PhoneNumberResult>(ChoosePhoneNumberTaskCompleted);

        }

        private void ChoosePhoneNumberTaskCompleted(object sender, PhoneNumberResult e) 
        {
            new SmsComposeTask() { Body = "SMS wysłany z telefonu Windows Phone 7", To = e.PhoneNumber }.Show();  //textBox1.Text
        }

        private void button1_Click(object sender, RoutedEventArgs e)
        {
            _choosePhoneNumberTask.Show();
        }

        protected override void OnNavigatedTo(System.Windows.Navigation.NavigationEventArgs e)
        {
            Debug.WriteLine("Przejście do strony głównej");

            if (State.ContainsKey("TextboxText"))
            {
                string strTextboxText = State["TextboxText"] as string;

                if (null != strTextboxText)
                    textBox1.Text = strTextboxText;
            }
            else
            {
                LoadAppStateDataAsync();
            }

            base.OnNavigatedTo(e);
        }

        protected override void OnNavigatedFrom(System.Windows.Navigation.NavigationEventArgs e)
        {
            Debug.WriteLine("Opuszczenie strony głównej");
            
            if (State.ContainsKey("TextboxText"))
                State.Remove("TextboxText");

            State.Add("TextboxText", textBox1.Text);

            base.OnNavigatedFrom(e);
        }

        protected override void OnBackKeyPress(System.ComponentModel.CancelEventArgs e)
        {
            base.OnBackKeyPress(e);
            MessageBoxResult res = MessageBox.Show("Czy chcesz zapisać swoją pracę przed wyjściem?", "Opuszczasz aplikację", MessageBoxButton.OKCancel);

            if (res == MessageBoxResult.OK)
            {
                Debug.WriteLine("Ok");
                SaveString(textBox1.Text, "TextboxText.dat");
            }
            else
            {
                Debug.WriteLine("Cancel");
            }
        }

        private void SaveString(string strTextToSave, string fileName)
        {
            using (IsolatedStorageFile isf = IsolatedStorageFile.GetUserStoreForApplication())
            {
                //Zapis oznacza konieczność utworzenia nowego pliku
                using (IsolatedStorageFileStream fs = isf.CreateFile(fileName))
                {
                    using (StreamWriter write = new StreamWriter(fs))
                    {
                        write.WriteLine(strTextToSave);
                    }
                }
            }
        }

        private void button2_Click(object sender, RoutedEventArgs e)
        {
            WebBrowserTask webTask = new WebBrowserTask();
            webTask.Show();
            webTask.URL = "http://www.windowsphone.com";
        }

        public void LoadAppStateDataAsync()
        {
            Thread t = new Thread(new ThreadStart(LoadAppStateData));
            t.Start();
        }

        public void LoadAppStateData()
        {
            string strData = String.Empty;

            //Próba odczytania danych zapisanych uprzednie w izolowanej pamięci masowej
            using (IsolatedStorageFile isf = IsolatedStorageFile.GetUserStoreForApplication())
            {
                //Sprawdzenie, czy plik istnieje
                if (isf.FileExists("TextboxText.dat"))
                {
                    using (IsolatedStorageFileStream fs = isf.OpenFile("TextboxText.dat", System.IO.FileMode.Open))
                    {
                        using (StreamReader reader = new StreamReader(fs))
                        {
                            strData = reader.ReadToEnd();
                        }
                    }
                }
            }

            Dispatcher.BeginInvoke(() => { textBox1.Text = strData; });

        }

    }
}