Option Explicit
Dim strComputer, objWMI, collDrivers, objDriver, intDrivers
Dim objFSO, strFolder, objFile
'
' Wartoci poniszej zmiennej powinna by cieka dostpu
' do folderu, w ktrym zostanie utworzony plik tekstowy.
'
strFolder = "d:\kopiezapasowe\"
'
' Inicjowanie obiektu systemu plikw.
'
Set objFSO = CreateObject("Scripting.FileSystemObject")
'
' Tworzenie pliku tekstowego.
'
Set objFile = objFSO.CreateTextFile(strFolder & "sterowniki.txt", True)
'
' Pobieranie obiektu WMI.
'
strComputer = "."
Set objWMI = GetObject("winmgmts:\\" & strComputer)
'
' Zwracanie spisu sterownikw urzdze zainstalowanych w komputerze.
'
Set collDrivers = objWMI.ExecQuery _
    ("Select * from Win32_PnPSignedDriver")
'
' Ptla przechodzca przez kady element spisu.
'
intDrivers = 0
For Each objDriver in collDrivers
    '
    ' Zapisywanie danych o sterowniku do pliku tekstowego.
    '
    objFile.WriteLine(objDriver.DeviceName)
    objFile.WriteLine("========================================")
    objFile.WriteLine("Klasa urzdzenia: " & objDriver.DeviceClass)
    objFile.WriteLine("Opis urzdzenia: " & objDriver.Description)
    objFile.WriteLine("Numer identyfikacyjny urzdzenia: " & objDriver.DeviceID)
    objFile.WriteLine("Nazwa pliku INF: " & objDriver.InfName)
    objFile.WriteLine("Dostawca sterownika: " & objDriver.DriverProviderName)
    objFile.WriteLine("Wersja sterownika: " & objDriver.DriverVersion)
    objFile.WriteLine("Data sterownika: " & ReturnDriverDate(objDriver.DriverDate))
    objFile.WriteLine("")
    intDrivers = intDrivers + 1
Next
'
' Zamykanie pliku tekstowego.
'
objFile.Close
WScript.Echo "Zapisano " & intDrivers & " list sterownikw do pliku tekstowego."

'
' ReturnDriverDate()
' This function takes the driver datetime value and converts
' it to a friendlier date and time format
'
Function ReturnDriverDate(dDriverDate)
    Dim eventDay, eventMonth, eventYear
    Dim eventSecond, eventMinute, eventHour
    eventYear = Left(dDriverDate, 4)
    eventMonth = Mid(dDriverDate, 5, 2)
    eventDay = Mid(dDriverDate, 7, 2)
    eventHour = Mid(dDriverDate, 9, 2)
    eventMinute = Mid(dDriverDate, 11, 2)
    eventSecond = Mid(dDriverDate, 13, 2)
    ReturnDriverDate = DateSerial(eventYear, eventMonth, eventDay) & " " & _ 
                    TimeSerial(eventHour, eventMinute, eventSecond)
End Function