Option Explicit
Dim strComputer, strBIOS
Dim objWMI, objBIOS, objItem
'
' Pobieranie obiektu usug WMI.
'
strComputer = "atw-laptop2"
Set objWMI = GetObject("winmgmts:{impersonationLevel=impersonate}!\\" & _ 
    strComputer & "\root\cimv2")
'
' Pobieranie egzemplarza reprezentujcego BIOS.
'
Set objBIOS = objWMI.ExecQuery("SELECT * FROM Win32_BIOS WHERE PrimaryBIOS = true")
'
' Inicjowanie acucha znakw.
'
strBIOS = "Dane na temat BIOS-u komputera " & UCase(strComputer) & ":" & vbCrLf & vbCrLf
'
' Pobieranie danych BIOS-u.
'
For Each objItem in objBIOS
	strBIOS = strBIOS & _
	          "Nazwa BIOS-u:" & vbTab & objItem.Name & vbCrLf & _
	          "Producent:" & vbTab & objItem.Manufacturer & vbCrLf & _
	          "Wersja BIOS-u:" & vbTab & objItem.Version & vbCrLf & _
	          "Wersja SMBIOS-u:" & vbTab & objItem.SMBIOSBIOSVersion & vbCrLf & _
	          "Data wydania:" & vbTab & ConvertToDate(objItem.ReleaseDate)

Next
'
' Wywietlanie acucha znakw.
'
WScript.Echo strBIOS
'
' Zwalnianie obiektw.
'
Set objWMI = Nothing
Set objBIOS = Nothing
Set objItem = Nothing
'
' Ta funkcja przyjmuje acuch z dat i czasem, aby
' przeksztaci go na obiekt typu Date.
'
Function ConvertToDate(strDate)
    Dim strYear, strMonth, strDay
    strYear = Left(strDate, 4)
    strMonth = Mid(strDate, 5, 2)
    strDay = Mid(strDate, 7, 2)
    ConvertToDate = DateSerial(strYear, strMonth, strDay)
End Function