﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Runtime.Serialization;
using System.Xml.Serialization;
using System.Xml;
using PersonalInformationService.DataTransferObjects;

namespace PersonalInformationService.MessageSizeTest
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Messages size test.\n");
            RunTestStep(100);       //100B
            RunTestStep(1000);      //1kB
            RunTestStep(10000);     //10kB
            RunTestStep(100000);    //100kB
            //RunTestStep(500000);    //500kB
            RunTestStep(1000000);   //1MB

            Console.WriteLine("\nPress enter to close.");
            Console.ReadLine();
        }

        private static void RunTestStep(int photoSize)
        {
            Console.ForegroundColor = ConsoleColor.Green;
            Console.WriteLine("Test for additional data size {0}.", photoSize);
            Console.ResetColor();

            var pi = new ExtendedPersonDto(photoSize) { Name = "Maciej Grabek", Gender = GenderDto.Male };
            pi.Hobbies.Add(new HobbyDto() { Name = "Family", PercentageTime = 80 });
            pi.Hobbies.Add(new HobbyDto() { Name = "Technology", PercentageTime = 20 });

            MemoryStream ms = new MemoryStream();
            DataContractSerializer dcs = new DataContractSerializer(typeof(ExtendedPersonDto));
            //vs
            XmlSerializer xmls = new XmlSerializer(typeof(ExtendedPersonDto));

            XmlDictionaryWriter tw = XmlDictionaryWriter.CreateTextWriter(ms);
            RunDataContractSerializerTest(dcs, pi, ms, tw, "Text + DCS");
            RunXMLSerializerTest(xmls, pi, ms, tw, "Text + XML");

            tw = XmlDictionaryWriter.CreateMtomWriter(ms = new MemoryStream(), Encoding.UTF8, Int32.MaxValue, "");
            RunDataContractSerializerTest(dcs, pi, ms, tw, "MTOM + DCS");
            RunXMLSerializerTest(xmls, pi, ms, tw, "MTOM + XML");

            tw = XmlDictionaryWriter.CreateBinaryWriter(ms = new MemoryStream());
            RunDataContractSerializerTest(dcs, pi, ms, tw, "Binary + DCS");
            RunXMLSerializerTest(xmls, pi, ms, tw, "Binary + XML");
        }

        private static void RunDataContractSerializerTest(DataContractSerializer dcs, ExtendedPersonDto pi, MemoryStream ms, XmlDictionaryWriter tw, string label)
        {
            dcs.WriteObject(tw, pi);
            tw.Flush();
            DumpStream(ms, label, false);
        }

        private static void RunXMLSerializerTest(XmlSerializer xmls, ExtendedPersonDto pi, MemoryStream ms, XmlDictionaryWriter tw, string label)
        {
            xmls.Serialize(tw, pi);
            tw.Flush();
            DumpStream(ms, label, false);
        }

        private static void DumpStream(MemoryStream s, string type, bool withContent)
        {
            Console.WriteLine("{0} - Content length: {1} bytes", type, s.Length);

            if (withContent)
            {
                Console.ForegroundColor = ConsoleColor.DarkGray;
                s.WriteTo(Console.OpenStandardOutput());
                Console.ResetColor();
                Console.WriteLine();
            }
        } 
    }
}
