﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using CallbackDemoService;
using System.ServiceModel.Description;

namespace CallbackDemoHost
{
    class Program
    {
        static void Main(string[] args)
        {
            Uri baseAddr = new Uri("net.tcp://localhost:9002/SampleContract");
            using (ServiceHost host = new ServiceHost(typeof(SampleContract), baseAddr))
            {
                Console.WriteLine("Sample Contract Service host starting");
                host.Open();

                foreach (ServiceEndpoint se in host.Description.Endpoints)
                {
                    Console.WriteLine("\nAddress: {0}, \n\tBinding: {1}, \n\tContract: {2}", se.Address, se.Binding.Name, se.Contract.Name);
                }

                Console.WriteLine("Press [ENTER] to stop service...");
                Console.ReadLine();
            }
        }
    }
}
