﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using System.ServiceModel.Discovery;
using System.ServiceModel.Description;

namespace PersonalInformationHosts.Proxy
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Proxy Service is starting");
            //address for client
            Uri probeEndpointAddress = new Uri("net.tcp://localhost:9001/DiscoveryProbe");
            
            using (ServiceHost proxyServiceHost = new ServiceHost(new DiscoveryProxyService()))
            {
                DiscoveryEndpoint discoveryEndpoint =
                    new DiscoveryEndpoint(new NetTcpBinding(), new EndpointAddress(probeEndpointAddress));
                discoveryEndpoint.IsSystemEndpoint = false;

                AnnouncementEndpoint announcementEndpoint = new UdpAnnouncementEndpoint();

                proxyServiceHost.AddServiceEndpoint(discoveryEndpoint);
                proxyServiceHost.AddServiceEndpoint(announcementEndpoint);

                proxyServiceHost.Open();

                foreach (ServiceEndpoint se in proxyServiceHost.Description.Endpoints)
                {
                    Console.WriteLine("\nAddress: {0}, \n\tBinding: {1}, \n\tContract: {2}", se.Address, se.Binding.Name, se.Contract.Name);
                }

                Console.WriteLine("Proxy Service started.");
                Console.WriteLine("Press enter to close");
                Console.ReadLine();
            }
        }
    }
}