﻿using System;
using System.ServiceModel;
using PersonalInformationService.ServiceImplementations;
using System.ServiceModel.Description;
using PersonalInformationService.ServiceContracts;

namespace PersonalInformationHosts.SelfHost
{
    class Program
    {
        static void Main(string[] args)
        {
            RunHost();
        }

        private static void RunHost()
        {
            using (ServiceHost host = new ServiceHost(typeof(SimplePersonalInformationService)))
            {
                Console.WriteLine("Personal Information Service host is starting");
                foreach (ServiceEndpoint se in host.Description.Endpoints)
                {
                    Console.WriteLine("\nAddress: {0}, \n\tBinding: {1}, \n\tContract: {2}", se.Address, se.Binding.Name, se.Contract.Name);
                }

                //run host
                host.Open();
                Console.WriteLine("Press [ENTER] to stop service...");
                Console.ReadLine();
            }
        }
    }
}