﻿using System;
using System.ServiceModel.Configuration;
using System.ServiceModel.Description;

namespace PersonalServiceExtensions
{
    public class CustomServiceBehaviorExtension : BehaviorExtensionElement, IServiceBehavior
    {
        #region IServiceBehavior
        public void AddBindingParameters(ServiceDescription serviceDescription, System.ServiceModel.ServiceHostBase serviceHostBase, System.Collections.ObjectModel.Collection<ServiceEndpoint> endpoints, System.ServiceModel.Channels.BindingParameterCollection bindingParameters)
        {
            Console.WriteLine("\nAddBindingParameters is called.");
            foreach (var item in bindingParameters)
            {
                Console.WriteLine(item.ToString());
            }
            return;
        }

        public void ApplyDispatchBehavior(ServiceDescription serviceDescription, System.ServiceModel.ServiceHostBase serviceHostBase)
        {
            Console.WriteLine("\nThe PersonalServiceExtension has been applied to {0}.", serviceDescription.Name);
        }

        public void Validate(ServiceDescription serviceDescription, System.ServiceModel.ServiceHostBase serviceHostBase)
        {
            Console.WriteLine("\nValidate is called.");
            foreach (ServiceEndpoint se in serviceDescription.Endpoints)
            {
                Console.WriteLine(se.Address);
            }
        }
        #endregion

        #region BehaviorExtensionElement
        public override Type BehaviorType
        {
            get { return typeof(CustomServiceBehaviorExtension); }
        }

        protected override object CreateBehavior()
        {
            return new CustomServiceBehaviorExtension();
        }
        #endregion
    }
}
