﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using PersonalInformationClients.AsyncClient.IPersonalInformationServiceReference;

namespace PersonalInformationClients.AsyncClient
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Press [ENTER] to call PersonalInformationService");
            Console.ReadLine();

            using (PersonalInformationServiceClient client = new PersonalInformationServiceClient("BasicHttpBinding_IPersonalInformationService"))
            {
                client.GetPersonalInformationCompleted += new EventHandler<GetPersonalInformationCompletedEventArgs>(client_GetPersonalInformationCompleted);
                client.GetPersonalInformationAsync(
                    new PersonalInformationRequest()
                    {
                        PersonId = 1
                    });
            }

            Console.WriteLine("Press [ENTER] to close client");
            Console.ReadLine();
        }

        static void client_GetPersonalInformationCompleted(object sender, GetPersonalInformationCompletedEventArgs e)
        {
            Console.WriteLine("Received response");
            foreach (var person in e.Result.Persons)
            {
                Console.WriteLine("{0} : {1} {2}", person.Id, person.Name, person.Surname);
            }
        }
    }
}
