import * as actions from 'src/vuex/actions'
import { CHANGE_TITLE, POPULATE_SHOPPING_LISTS, ADD_SHOPPING_LIST, DELETE_SHOPPING_LIST } from 'src/vuex/mutation_types'

describe('actions.js', () => {
  var server, store, lists, successPut, successPost, successDelete;

  successDelete = {'delete': true}
  successPost = {'post': true}
  successPut = {'put': true}

  beforeEach(function () {
    // imituj listy zakupów
    lists = [{
      id: '1',
      title: 'Artykuły spożywcze'
    }, {
      id: '2',
      title: 'Ubrania'
    }]

    // imituj metodę dispatch magazynu
    store = {
      dispatch: (method, data) => {},
      state: {
        shoppinglists: lists
      }
    }
    sinon.stub(store, 'dispatch')

    // imituj serwer
    server = sinon.fakeServer.create()
    server.respondWith('GET', /shoppinglists/, xhr => {
      xhr.respond(200, {"Content-Type": "application/json"}, JSON.stringify(lists));
    })
    server.respondWith('POST', /shoppinglists/, xhr => {
      xhr.respond(200, {"Content-Type": "application/json"}, JSON.stringify(successPost))
    })
    server.respondWith('PUT', /shoppinglists/, xhr => {
      xhr.respond(200, {"Content-Type": "application/json"}, JSON.stringify(successPut))
    })
    server.respondWith('DELETE', /shoppinglists/, xhr => {
      xhr.respond(200, {"Content-Type": "application/json"}, JSON.stringify(successDelete))
    })
    server.autoRespond = true
  })

  afterEach(function () {
    // przywróć atrapy i imitację serwera do pierwotnego stanu
    store.dispatch.restore()
    server.restore()
  })

  describe('populateShoppingLists', () => {
    it('powinna sprawdzić, czy metoda dispatch jest wywoływana z argumentami POPULATE_SHOPPING_LIST i imitacją list', done => {
      actions.populateShoppingLists(store).then(() => {
        expect(store.dispatch).to.have.been.calledWith(POPULATE_SHOPPING_LISTS, lists)
        done()
      }).catch(done)
    })
  })

  describe('changeTitle', () => {
    it('powinna wywołać metodę dispatch z ciągiem znaków CHANGE_TITLE', (done) => {
      let title = 'nowa nazwa'

      actions.changeTitle(store, title, '1').then((data) => {
        expect(store.dispatch).to.have.been.calledWith(CHANGE_TITLE, title, '1')
        expect(data.data).to.eql(successPut)
        done()
      }).catch(done)
    })
  })
})
