var Emitter, array;

array = require('./array');

module.exports = Emitter = (function() {
  function Emitter() {
    this._listeners = {};
    this._listenersForAnyEvent = [];
    this._disabledEmitters = {};
  }

  Emitter.prototype.on = function(eventName, listener) {
    if (this._listeners[eventName] == null) {
      this._listeners[eventName] = [];
    }
    this._listeners[eventName].push(listener);
    return this;
  };

  Emitter.prototype.once = function(eventName, listener) {
    var cb, ran;
    ran = false;
    cb = (function(_this) {
      return function() {
        if (ran) {
          return;
        }
        ran = true;
        listener();
        return setTimeout(function() {
          return _this.removeEvent(eventName, cb);
        }, 0);
      };
    })(this);
    this.on(eventName, cb);
    return this;
  };

  Emitter.prototype.onAnyEvent = function(listener) {
    this._listenersForAnyEvent.push(listener);
    return this;
  };

  Emitter.prototype.removeEvent = function(eventName, listener) {
    if (this._listeners[eventName] == null) {
      return this;
    }
    array.pluckOneItem(this._listeners[eventName], listener);
    return this;
  };

  Emitter.prototype.removeListeners = function(eventName) {
    if (this._listeners[eventName] == null) {
      return this;
    }
    this._listeners[eventName].length = 0;
    return this;
  };

  Emitter.prototype.removeAllListeners = function() {
    var listeners, name, _ref;
    _ref = this._listeners;
    for (name in _ref) {
      listeners = _ref[name];
      listeners.length = 0;
    }
    return this;
  };

  Emitter.prototype._emit = function(eventName, data) {
    var listener, _i, _j, _len, _len1, _ref, _ref1;
    _ref = this._listenersForAnyEvent;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      listener = _ref[_i];
      listener.call(this, data, eventName);
    }
    if (this._listeners[eventName] == null) {
      return;
    }
    _ref1 = this._listeners[eventName];
    for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
      listener = _ref1[_j];
      listener.call(this, data);
    }
  };

  Emitter.prototype._throttleEmitterMethod = function(fnName, time) {
    var lastCallArgs, originalFn, pend, pending, runIt, timer;
    if (time == null) {
      time = 1000;
    }
    originalFn = this[fnName];
    if (typeof originalFn !== 'function') {
      throw Error("this class does not have a method called '" + fnName + "'");
    }
    lastCallArgs = null;
    pending = false;
    timer = null;
    this[fnName] = (function(_this) {
      return function() {
        lastCallArgs = arguments;
        return pend();
      };
    })(this);
    pend = (function(_this) {
      return function() {
        if (pending) {
          clearTimeout(timer);
        }
        timer = setTimeout(runIt, time);
        return pending = true;
      };
    })(this);
    return runIt = (function(_this) {
      return function() {
        pending = false;
        return originalFn.apply(_this, lastCallArgs);
      };
    })(this);
  };

  Emitter.prototype._disableEmitter = function(fnName) {
    if (this._disabledEmitters[fnName] != null) {
      throw Error("" + fnName + " is already a disabled emitter");
    }
    this._disabledEmitters[fnName] = this[fnName];
    return this[fnName] = function() {};
  };

  Emitter.prototype._enableEmitter = function(fnName) {
    var fn;
    fn = this._disabledEmitters[fnName];
    if (fn == null) {
      throw Error("" + fnName + " is not a disabled emitter");
    }
    this[fnName] = fn;
    return delete this._disabledEmitters[fnName];
  };

  return Emitter;

})();

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiRW1pdHRlci5qcyIsInNvdXJjZVJvb3QiOiIuLlxcLi4iLCJzb3VyY2VzIjpbImNvZmZlZVxcbGliXFxFbWl0dGVyLmNvZmZlZSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxJQUFBLGNBQUE7O0FFQUEsS0VBQSxHRUFRLE9FQUEsQ0VBUSxTRUFSLENBQVIsQ0FBQTs7QUVFQSxNRUFNLENFQUMsT0VBUCxHRUF1QjtBRUVULEVFQUEsaUJFQUEsR0VBQTtBRUVaLElFQUEsSUVBQyxDRUFBLFVFQUQsR0VBYyxFRUFkLENFQUE7QUVBQSxJRUVBLElFQUMsQ0VBQSxxQkVBRCxHRUF5QixFRUZ6QixDRUFBO0FFQUEsSUVJQSxJRUFDLENFQUEsaUJFQUQsR0VBcUIsRUVKckIsQ0VGWTtFRUFBLENFQWI7O0FFQUEsb0JFUUEsRUVBQSxHRUFJLFNFQUMsU0VBRCxFRUFZLFFFQVosR0VBQTtBRUVILElFQUEsSUVBTyxrQ0VBUDtBRUVDLE1FQUEsSUVBQyxDRUFBLFVFQVcsQ0VBQSxTRUFBLENFQVosR0VBeUIsRUVBekIsQ0VGRDtLRUFBO0FFQUEsSUVJQSxJRUFDLENFQUEsVUVBVyxDRUFBLFNFQUEsQ0VBVSxDRUFDLElFQXZCLENFQTRCLFFFQTVCLENFSkEsQ0VBQTtXRU1BLEtFUkc7RUVBQSxDRVJKLENFQUE7O0FFQUEsb0JFa0JBLElFQUEsR0VBTSxTRUFDLFNFQUQsRUVBWSxRRUFaLEdFQUE7QUVFTCxRRUFBLE9FQUE7QUVBQSxJRUFBLEdFQUEsR0VBTSxLRUFOLENFQUE7QUVBQSxJRUVBLEVFQUEsR0VBSyxDRUFBLFNFQUEsS0VBQSxHRUFBO2FFQUEsU0VBQSxHRUFBO0FFRUosUUVBQSxJRUFVLEdFQVY7QUVBQSxnQkVBQSxDRUFBO1NFQUE7QUVBQSxRRUVBLEdFQUEsR0VBTSxJRUZOLENFQUE7QUVBQSxRRUlHLFFFQUgsQ0VBQSxDRUpBLENFQUE7ZUVNQSxVRUFBLENFQVcsU0VBQSxHRUFBO2lCRUVWLEtFQUMsQ0VBQSxXRUFELENFQWEsU0VBYixFRUF3QixFRUF4QixFRUZVO1FFQUEsQ0VBWCxFRUlFLENFSkYsRUVSSTtNRUFBLEVFQUE7SUVBQSxDRUFBLENFQUEsQ0VBQSxJRUFBLENFRkwsQ0VBQTtBRUFBLElFZ0JBLElFQUMsQ0VBQSxFRUFELENFQUksU0VBSixFRUFlLEVFQWYsQ0VoQkEsQ0VBQTtXRWtCQSxLRXBCSztFRUFBLENFbEJOLENFQUE7O0FFQUEsb0JFd0NBLFVFQUEsR0VBWSxTRUFDLFFFQUQsR0VBQTtBRUVYLElFQUEsSUVBQyxDRUFBLHFCRUFxQixDRUFDLElFQXZCLENFQTRCLFFFQTVCLENFQUEsQ0VBQTtXRUVBLEtFSlc7RUVBQSxDRXhDWixDRUFBOztBRUFBLG9CRThDQSxXRUFBLEdFQWEsU0VBQyxTRUFELEVFQVksUUVBWixHRUFBO0FFRVosSUVBQSxJRUFnQixrQ0VBaEI7QUVBQSxhRUFPLElFQVAsQ0VBQTtLRUFBO0FFQUEsSUVFQSxLRUFLLENFQUMsWUVBTixDRUFtQixJRUFDLENFQUEsVUVBVyxDRUFBLFNFQUEsQ0VBL0IsRUVBMkMsUUVBM0MsQ0VGQSxDRUFBO1dFSUEsS0VOWTtFRUFBLENFOUNiLENFQUE7O0FFQUEsb0JFc0RBLGVFQUEsR0VBaUIsU0VBQyxTRUFELEdFQUE7QUVFaEIsSUVBQSxJRUFnQixrQ0VBaEI7QUVBQSxhRUFPLElFQVAsQ0VBQTtLRUFBO0FFQUEsSUVFQSxJRUFDLENFQUEsVUVBVyxDRUFBLFNFQUEsQ0VBVSxDRUFDLE1FQXZCLEdFQWdDLENFRmhDLENFQUE7V0VJQSxLRU5nQjtFRUFBLENFdERqQixDRUFBOztBRUFBLG9CRThEQSxrQkVBQSxHRUFvQixTRUFBLEdFQUE7QUVFbkIsUUVBQSxxQkVBQTtBRUFBO0FFQUEsU0VBQSxZRUFBOzZCRUFBO0FFRUMsTUVBQSxTRUFTLENFQUMsTUVBVixHRUFtQixDRUFuQixDRUZEO0FFQUEsS0VBQTtXRUlBLEtFTm1CO0VFQUEsQ0U5RHBCLENFQUE7O0FFQUEsb0JFc0VBLEtFQUEsR0VBTyxTRUFDLFNFQUQsRUVBWSxJRUFaLEdFQUE7QUVFTixRRUFBLDBDRUFBO0FFQUE7QUVBQSxTRUFBLDJDRUFBOzBCRUFBO0FFRUMsTUVBQSxRRUFRLENFQUMsSUVBVCxDRUFjLElFQWQsRUVBaUIsSUVBakIsRUVBdUIsU0VBdkIsQ0VBQSxDRUZEO0FFQUEsS0VBQTtBRUlBLElFQUEsSUVBYyxrQ0VBZDtBRUFBLFlFQUEsQ0VBQTtLRUpBO0FFTUE7QUVBQSxTRUFBLDhDRUFBOzJCRUFBO0FFRUMsTUVBQSxRRUFRLENFQUMsSUVBVCxDRUFjLElFQWQsRUVBaUIsSUVBakIsQ0VBQSxDRUZEO0FFQUEsS0VSTTtFRUFBLENFdEVQLENFQUE7O0FFQUEsb0JFc0ZBLHNCRUFBLEdFQXdCLFNFQUMsTUVBRCxFRUFTLElFQVQsR0VBQTtBRUV2QixRRUFBLHFERUFBOztNRUZnQyxPRUFPO0tFRXZDO0FFQUEsSUVBQSxVRUFBLEdFQWEsSUVBRSxDRUFBLE1FQUEsQ0VBZixDRUFBO0FFRUEsSUVBQSxJRUFHLE1FQUEsQ0VBTyxVRUFQLEtFQXVCLFVFQTFCO0FFRUMsWUVBTSxLRUFBLENFQU8sNENFQUEsR0VBMkMsTUVBM0MsR0VBbUQsR0VBMUQsQ0VBTixDRUZEO0tFRkE7QUVBQSxJRU1BLFlFQUEsR0VBZSxJRU5mLENFQUE7QUVBQSxJRU9BLE9FQUEsR0VBVSxLRVBWLENFQUE7QUVBQSxJRVFBLEtFQUEsR0VBUSxJRVJSLENFQUE7QUVBQSxJRVVBLElFQUUsQ0VBQSxNRUFBLENFQUYsR0VBWSxDRUFBLFNFQUEsS0VBQSxHRUFBO2FFQUEsU0VBQSxHRUFBO0FFRVgsUUVBQSxZRUFBLEdFQWUsU0VBZixDRUFBO2VFRUcsSUVBSCxDRUFBLEVFSlc7TUVBQSxFRUFBO0lFQUEsQ0VBQSxDRUFBLENFQUEsSUVBQSxDRVZaLENFQUE7QUVBQSxJRWdCQSxJRUFBLEdFQU8sQ0VBQSxTRUFBLEtFQUEsR0VBQTthRUFBLFNFQUEsR0VBQTtBRUVOLFFFQUEsSUVBRyxPRUFIO0FFRUMsVUVBQSxZRUFBLENFQWEsS0VBYixDRUFBLENFRkQ7U0VBQTtBRUFBLFFFSUEsS0VBQSxHRUFRLFVFQUEsQ0VBVyxLRUFYLEVFQWtCLElFQWxCLENFSlIsQ0VBQTtlRU1BLE9FQUEsR0VBVSxLRVJKO01FQUEsRUVBQTtJRUFBLENFQUEsQ0VBQSxDRUFBLElFQUEsQ0VoQlAsQ0VBQTtXRTBCQSxLRUFBLEdFQVEsQ0VBQSxTRUFBLEtFQUEsR0VBQTthRUFBLFNFQUEsR0VBQTtBRUVQLFFFQUEsT0VBQSxHRUFVLEtFQVYsQ0VBQTtlRUVBLFVFQVUsQ0VBQyxLRUFYLENFQWlCLEtFQWpCLEVFQW9CLFlFQXBCLEVFSk87TUVBQSxFRUFBO0lFQUEsQ0VBQSxDRUFBLENFQUEsSUVBQSxFRTVCZTtFRUFBLENFdEZ4QixDRUFBOztBRUFBLG9CRXdIQSxlRUFBLEdFQWlCLFNFQUMsTUVBRCxHRUFBO0FFRWhCLElFQUEsSUVBRyxzQ0VBSDtBRUVDLFlFQU0sS0VBQSxDRUFNLEVFQUEsR0VBRSxNRUFGLEdFQVUsZ0NFQWhCLENFQU4sQ0VGRDtLRUFBO0FFQUEsSUVJQSxJRUFDLENFQUEsaUJFQWtCLENFQUEsTUVBQSxDRUFuQixHRUE2QixJRUFFLENFQUEsTUVBQSxDRUovQixDRUFBO1dFTUEsSUVBRSxDRUFBLE1FQUEsQ0VBRixHRUFZLFNFQUEsR0VBQSxFRVJJO0VFQUEsQ0V4SGpCLENFQUE7O0FFQUEsb0JFa0lBLGNFQUEsR0VBZ0IsU0VBQyxNRUFELEdFQUE7QUVFZixRRUFBLEVFQUE7QUVBQSxJRUFBLEVFQUEsR0VBSyxJRUFDLENFQUEsaUJFQWtCLENFQUEsTUVBQSxDRUF4QixDRUFBO0FFRUEsSUVBQSxJRUFPLFVFQVA7QUVFQyxZRUFNLEtFQUEsQ0VBTSxFRUFBLEdFQUUsTUVBRixHRUFVLDRCRUFoQixDRUFOLENFRkQ7S0VGQTtBRUFBLElFTUEsSUVBRSxDRUFBLE1FQUEsQ0VBRixHRUFZLEVFTlosQ0VBQTtXRVFBLE1FQUEsQ0VBTyxJRUFDLENFQUEsaUJFQWtCLENFQUEsTUVBQSxFRVZYO0VFQUEsQ0VsSWhCLENFQUE7O2lCRUFBOztJQUpELENBQUEiLCJzb3VyY2VzQ29udGVudCI6WyJtb2R1bGUuZXhwb3J0cyA9IGFycmF5ID1cblxuXHQjIyNcblx0VHJpZXMgdG8gdHVybiBhbnl0aGluZyBpbnRvIGFuIGFycmF5LlxuXHQjIyNcblx0ZnJvbTogKHIpIC0+XG5cblx0XHRBcnJheTo6c2xpY2UuY2FsbCByXG5cblx0IyMjXG5cdENsb25lIG9mIGFuIGFycmF5LiBQcm9wZXJ0aWVzIHdpbGwgYmUgc2hhbGxvdyBjb3BpZXMuXG5cdCMjI1xuXHRzaW1wbGVDbG9uZTogKGEpIC0+XG5cblx0XHRhLnNsaWNlIDBcblxuXHRzaGFsbG93RXF1YWw6IChhMSwgYTIpIC0+XG5cblx0XHRyZXR1cm4gbm8gdW5sZXNzIEFycmF5LmlzQXJyYXkoYTEpIGFuZCBBcnJheS5pc0FycmF5KGEyKSBhbmQgYTEubGVuZ3RoIGlzIGEyLmxlbmd0aFxuXG5cdFx0Zm9yIHZhbCwgaSBpbiBhMVxuXG5cdFx0XHRyZXR1cm4gbm8gdW5sZXNzIGEyW2ldIGlzIHZhbFxuXG5cdFx0eWVzXG5cblx0cGx1Y2s6IChhLCBpKSAtPlxuXG5cdFx0cmV0dXJuIGEgaWYgYS5sZW5ndGggPCAxXG5cblxuXHRcdGZvciB2YWx1ZSwgaW5kZXggaW4gYVxuXG5cdFx0XHRpZiBpbmRleCA+IGlcblxuXHRcdFx0XHRhW2luZGV4IC0gMV0gPSBhW2luZGV4XVxuXG5cdFx0YS5sZW5ndGggPSBhLmxlbmd0aCAtIDFcblxuXHRcdGFcblxuXHRwbHVja0l0ZW06IChhLCBpdGVtKSAtPlxuXG5cdFx0cmV0dXJuIGEgaWYgYS5sZW5ndGggPCAxXG5cblxuXHRcdHJlbW92ZWQgPSAwXG5cblx0XHRmb3IgdmFsdWUsIGluZGV4IGluIGFcblxuXHRcdFx0aWYgdmFsdWUgaXMgaXRlbVxuXG5cdFx0XHRcdHJlbW92ZWQrK1xuXG5cdFx0XHRcdGNvbnRpbnVlXG5cblx0XHRcdGlmIHJlbW92ZWQgaXNudCAwXG5cblx0XHRcdFx0YVtpbmRleCAtIHJlbW92ZWRdID0gYVtpbmRleF1cblxuXHRcdGEubGVuZ3RoID0gYS5sZW5ndGggLSByZW1vdmVkIGlmIHJlbW92ZWQgPiAwXG5cblx0XHRhXG5cblx0cGx1Y2tPbmVJdGVtOiAoYSwgaXRlbSkgLT5cblxuXHRcdHJldHVybiBhIGlmIGEubGVuZ3RoIDwgMVxuXG5cdFx0cmVhY2hlZCA9IG5vXG5cblx0XHRmb3IgdmFsdWUsIGluZGV4IGluIGFcblxuXHRcdFx0aWYgbm90IHJlYWNoZWRcblxuXHRcdFx0XHRpZiB2YWx1ZSBpcyBpdGVtXG5cblx0XHRcdFx0XHRyZWFjaGVkID0geWVzXG5cblx0XHRcdFx0XHRjb250aW51ZVxuXG5cdFx0XHRlbHNlXG5cblx0XHRcdFx0YVtpbmRleCAtIDFdID0gYVtpbmRleF1cblxuXHRcdGEubGVuZ3RoID0gYS5sZW5ndGggLSAxIGlmIHJlYWNoZWRcblxuXHRcdGFcblxuXHRwbHVja0J5Q2FsbGJhY2s6IChhLCBjYikgLT5cblxuXHRcdHJldHVybiBhIGlmIGEubGVuZ3RoIDwgMVxuXG5cdFx0cmVtb3ZlZCA9IDBcblxuXHRcdGZvciB2YWx1ZSwgaW5kZXggaW4gYVxuXG5cdFx0XHRpZiBjYiB2YWx1ZSwgaW5kZXhcblxuXHRcdFx0XHRyZW1vdmVkKytcblxuXHRcdFx0XHRjb250aW51ZVxuXG5cdFx0XHRpZiByZW1vdmVkIGlzbnQgMFxuXG5cdFx0XHRcdGFbaW5kZXggLSByZW1vdmVkXSA9IGFbaW5kZXhdXG5cblx0XHRpZiByZW1vdmVkID4gMFxuXG5cdFx0XHRhLmxlbmd0aCA9IGEubGVuZ3RoIC0gcmVtb3ZlZFxuXG5cdFx0YVxuXG5cdHBsdWNrTXVsdGlwbGU6IChhcnJheSwgaW5kZXhlc1RvUmVtb3ZlKSAtPlxuXG5cdFx0cmV0dXJuIGFycmF5IGlmIGFycmF5Lmxlbmd0aCA8IDFcblxuXHRcdHJlbW92ZWRTb0ZhciA9IDBcblxuXHRcdGluZGV4ZXNUb1JlbW92ZS5zb3J0KClcblxuXHRcdGZvciBpIGluIGluZGV4ZXNUb1JlbW92ZVxuXG5cdFx0XHRAcGx1Y2sgYXJyYXksIGkgLSByZW1vdmVkU29GYXJcblxuXHRcdFx0cmVtb3ZlZFNvRmFyKytcblxuXHRcdGFycmF5XG5cblx0aW5qZWN0QnlDYWxsYmFjazogKGEsIHRvSW5qZWN0LCBzaG91bGRJbmplY3QpIC0+XG5cblx0XHR2YWxBID0gbnVsbFxuXG5cdFx0dmFsQiA9IG51bGxcblxuXHRcdGxlbiA9IGEubGVuZ3RoXG5cblx0XHRpZiBsZW4gPCAxXG5cblx0XHRcdGEucHVzaCB0b0luamVjdFxuXG5cdFx0XHRyZXR1cm4gYVxuXG5cblx0XHRmb3IgdmFsLCBpIGluIGFcblxuXHRcdFx0dmFsQSA9IHZhbEJcblxuXHRcdFx0dmFsQiA9IHZhbFxuXG5cdFx0XHRpZiBzaG91bGRJbmplY3QgdmFsQSwgdmFsQiwgdG9JbmplY3RcblxuXHRcdFx0XHRyZXR1cm4gYS5zcGxpY2UgaSwgMCwgdG9JbmplY3RcblxuXHRcdGEucHVzaCB0b0luamVjdFxuXG5cdFx0YVxuXG5cdGluamVjdEluSW5kZXg6IChhLCBpbmRleCwgdG9JbmplY3QpIC0+XG5cblx0XHRsZW4gPSBhLmxlbmd0aFxuXG5cdFx0aSA9IGluZGV4XG5cblx0XHRpZiBsZW4gPCAxXG5cblx0XHRcdGEucHVzaCB0b0luamVjdFxuXG5cdFx0XHRyZXR1cm4gYVxuXG5cdFx0dG9QdXQgPSB0b0luamVjdFxuXG5cdFx0dG9QdXROZXh0ID0gbnVsbFxuXG5cdFx0YGZvcig7IGkgPD0gbGVuOyBpKyspe1xuXG5cdFx0XHR0b1B1dE5leHQgPSBhW2ldO1xuXG5cdFx0XHRhW2ldID0gdG9QdXQ7XG5cblx0XHRcdHRvUHV0ID0gdG9QdXROZXh0O1xuXG5cdFx0fWBcblxuXHRcdCMgYVtpXSA9IHRvUHV0XG5cblx0XHRudWxsIiwibW9kdWxlLmV4cG9ydHMgPSBjbGFzc2ljID0ge31cblxuIyBMaXR0bGUgaGVscGVyIGZvciBtaXhpbnMgZnJvbSBDb2ZmZWVTY3JpcHQgRkFRLFxuIyBjb3VydGVzeSBvZiBTZXRoYXVydXMgKGh0dHA6Ly9naXRodWIuY29tL3NldGhhdXJ1cylcbmNsYXNzaWMuaW1wbGVtZW50ID0gKG1peGlucy4uLiwgY2xhc3NSZWZlcmVuY2UpIC0+XG5cblx0Zm9yIG1peGluIGluIG1peGluc1xuXG5cdFx0Y2xhc3NQcm90byA9IGNsYXNzUmVmZXJlbmNlOjpcblxuXHRcdGZvciBtZW1iZXIgb2YgbWl4aW46OlxuXG5cdFx0XHR1bmxlc3MgT2JqZWN0LmdldE93blByb3BlcnR5RGVzY3JpcHRvciBjbGFzc1Byb3RvLCBtZW1iZXJcblxuXHRcdFx0XHRkZXNjID0gT2JqZWN0LmdldE93blByb3BlcnR5RGVzY3JpcHRvciBtaXhpbjo6LCBtZW1iZXJcblxuXHRcdFx0XHRPYmplY3QuZGVmaW5lUHJvcGVydHkgY2xhc3NQcm90bywgbWVtYmVyLCBkZXNjXG5cblx0Y2xhc3NSZWZlcmVuY2VcblxuY2xhc3NpYy5taXggPSAobWl4aW5zLi4uLCBjbGFzc1JlZmVyZW5jZSkgLT5cblxuXHRjbGFzc1Byb3RvID0gY2xhc3NSZWZlcmVuY2U6OlxuXG5cdGNsYXNzUmVmZXJlbmNlLl9fbWl4aW5DbG9uZXJzID0gW11cblxuXHRjbGFzc1JlZmVyZW5jZS5fX2FwcGx5Q2xvbmVyc0ZvciA9IChpbnN0YW5jZSwgYXJncyA9IG51bGwpIC0+XG5cblx0XHRmb3IgY2xvbmVyIGluIGNsYXNzUmVmZXJlbmNlLl9fbWl4aW5DbG9uZXJzXG5cblx0XHRcdGNsb25lci5hcHBseSBpbnN0YW5jZSwgYXJnc1xuXG5cdFx0cmV0dXJuXG5cblx0Y2xhc3NSZWZlcmVuY2UuX19taXhpbkluaXRpYWxpemVycyA9IFtdXG5cblx0Y2xhc3NSZWZlcmVuY2UuX19pbml0TWl4aW5zRm9yID0gKGluc3RhbmNlLCBhcmdzID0gbnVsbCkgLT5cblxuXHRcdGZvciBpbml0aWFsaXplciBpbiBjbGFzc1JlZmVyZW5jZS5fX21peGluSW5pdGlhbGl6ZXJzXG5cblx0XHRcdGluaXRpYWxpemVyLmFwcGx5IGluc3RhbmNlLCBhcmdzXG5cblx0XHRyZXR1cm5cblxuXHRjbGFzc1JlZmVyZW5jZS5fX21peGluUXVpdHRlcnMgPSBbXVxuXG5cdGNsYXNzUmVmZXJlbmNlLl9fYXBwbHlRdWl0dGVyc0ZvciA9IChpbnN0YW5jZSwgYXJncyA9IG51bGwpIC0+XG5cblx0XHRmb3IgcXVpdHRlciBpbiBjbGFzc1JlZmVyZW5jZS5fX21peGluUXVpdHRlcnNcblxuXHRcdFx0cXVpdHRlci5hcHBseSBpbnN0YW5jZSwgYXJnc1xuXG5cdFx0cmV0dXJuXG5cblx0Zm9yIG1peGluIGluIG1peGluc1xuXG5cdFx0dW5sZXNzIG1peGluLmNvbnN0cnVjdG9yIGluc3RhbmNlb2YgRnVuY3Rpb25cblxuXHRcdFx0dGhyb3cgRXJyb3IgXCJNaXhpbiBzaG91bGQgYmUgYSBmdW5jdGlvblwiXG5cblx0XHRmb3IgbWVtYmVyIG9mIG1peGluOjpcblxuXHRcdFx0aWYgbWVtYmVyLnN1YnN0cigwLCAxMSkgaXMgJ19faW5pdE1peGluJ1xuXG5cdFx0XHRcdGNsYXNzUmVmZXJlbmNlLl9fbWl4aW5Jbml0aWFsaXplcnMucHVzaCBtaXhpbjo6W21lbWJlcl1cblxuXHRcdFx0XHRjb250aW51ZVxuXG5cdFx0XHRlbHNlIGlmIG1lbWJlci5zdWJzdHIoMCwgMTEpIGlzICdfX2Nsb25lckZvcidcblxuXHRcdFx0XHRjbGFzc1JlZmVyZW5jZS5fX21peGluQ2xvbmVycy5wdXNoIG1peGluOjpbbWVtYmVyXVxuXG5cdFx0XHRcdGNvbnRpbnVlXG5cblx0XHRcdGVsc2UgaWYgbWVtYmVyLnN1YnN0cigwLCAxMikgaXMgJ19fcXVpdHRlckZvcidcblxuXHRcdFx0XHRjbGFzc1JlZmVyZW5jZS5fX21peGluUXVpdHRlcnMucHVzaCBtaXhpbjo6W21lbWJlcl1cblxuXHRcdFx0XHRjb250aW51ZVxuXG5cdFx0XHR1bmxlc3MgT2JqZWN0LmdldE93blByb3BlcnR5RGVzY3JpcHRvciBjbGFzc1Byb3RvLCBtZW1iZXJcblxuXHRcdFx0XHRkZXNjID0gT2JqZWN0LmdldE93blByb3BlcnR5RGVzY3JpcHRvciBtaXhpbjo6LCBtZW1iZXJcblxuXHRcdFx0XHRPYmplY3QuZGVmaW5lUHJvcGVydHkgY2xhc3NQcm90bywgbWVtYmVyLCBkZXNjXG5cblx0Y2xhc3NSZWZlcmVuY2UiLCJhcnJheSA9IHJlcXVpcmUgJy4vYXJyYXknXHJcblxyXG5tb2R1bGUuZXhwb3J0cyA9IGNsYXNzIEVtaXR0ZXJcclxuXHJcblx0Y29uc3RydWN0b3I6IC0+XHJcblxyXG5cdFx0QF9saXN0ZW5lcnMgPSB7fVxyXG5cclxuXHRcdEBfbGlzdGVuZXJzRm9yQW55RXZlbnQgPSBbXVxyXG5cclxuXHRcdEBfZGlzYWJsZWRFbWl0dGVycyA9IHt9XHJcblxyXG5cdG9uOiAoZXZlbnROYW1lLCBsaXN0ZW5lcikgLT5cclxuXHJcblx0XHR1bmxlc3MgQF9saXN0ZW5lcnNbZXZlbnROYW1lXT9cclxuXHJcblx0XHRcdEBfbGlzdGVuZXJzW2V2ZW50TmFtZV0gPSBbXVxyXG5cclxuXHRcdEBfbGlzdGVuZXJzW2V2ZW50TmFtZV0ucHVzaCBsaXN0ZW5lclxyXG5cclxuXHRcdEBcclxuXHJcblx0b25jZTogKGV2ZW50TmFtZSwgbGlzdGVuZXIpIC0+XHJcblxyXG5cdFx0cmFuID0gbm9cclxuXHJcblx0XHRjYiA9ID0+XHJcblxyXG5cdFx0XHRyZXR1cm4gaWYgcmFuXHJcblxyXG5cdFx0XHRyYW4gPSB5ZXNcclxuXHJcblx0XHRcdGRvIGxpc3RlbmVyXHJcblxyXG5cdFx0XHRzZXRUaW1lb3V0ID0+XHJcblxyXG5cdFx0XHRcdEByZW1vdmVFdmVudCBldmVudE5hbWUsIGNiXHJcblxyXG5cdFx0XHQsIDBcclxuXHJcblx0XHRAb24gZXZlbnROYW1lLCBjYlxyXG5cclxuXHRcdEBcclxuXHJcblx0b25BbnlFdmVudDogKGxpc3RlbmVyKSAtPlxyXG5cclxuXHRcdEBfbGlzdGVuZXJzRm9yQW55RXZlbnQucHVzaCBsaXN0ZW5lclxyXG5cclxuXHRcdEBcclxuXHJcblx0cmVtb3ZlRXZlbnQ6IChldmVudE5hbWUsIGxpc3RlbmVyKSAtPlxyXG5cclxuXHRcdHJldHVybiBAIHVubGVzcyBAX2xpc3RlbmVyc1tldmVudE5hbWVdP1xyXG5cclxuXHRcdGFycmF5LnBsdWNrT25lSXRlbSBAX2xpc3RlbmVyc1tldmVudE5hbWVdLCBsaXN0ZW5lclxyXG5cclxuXHRcdEBcclxuXHJcblx0cmVtb3ZlTGlzdGVuZXJzOiAoZXZlbnROYW1lKSAtPlxyXG5cclxuXHRcdHJldHVybiBAIHVubGVzcyBAX2xpc3RlbmVyc1tldmVudE5hbWVdP1xyXG5cclxuXHRcdEBfbGlzdGVuZXJzW2V2ZW50TmFtZV0ubGVuZ3RoID0gMFxyXG5cclxuXHRcdEBcclxuXHJcblx0cmVtb3ZlQWxsTGlzdGVuZXJzOiAtPlxyXG5cclxuXHRcdGZvciBuYW1lLCBsaXN0ZW5lcnMgb2YgQF9saXN0ZW5lcnNcclxuXHJcblx0XHRcdGxpc3RlbmVycy5sZW5ndGggPSAwXHJcblxyXG5cdFx0QFxyXG5cclxuXHRfZW1pdDogKGV2ZW50TmFtZSwgZGF0YSkgLT5cclxuXHJcblx0XHRmb3IgbGlzdGVuZXIgaW4gQF9saXN0ZW5lcnNGb3JBbnlFdmVudFxyXG5cclxuXHRcdFx0bGlzdGVuZXIuY2FsbCBALCBkYXRhLCBldmVudE5hbWVcclxuXHJcblx0XHRyZXR1cm4gdW5sZXNzIEBfbGlzdGVuZXJzW2V2ZW50TmFtZV0/XHJcblxyXG5cdFx0Zm9yIGxpc3RlbmVyIGluIEBfbGlzdGVuZXJzW2V2ZW50TmFtZV1cclxuXHJcblx0XHRcdGxpc3RlbmVyLmNhbGwgQCwgZGF0YVxyXG5cclxuXHRcdHJldHVyblxyXG5cclxuXHQjIHRoaXMgbWFrZXMgc3VyZSB0aGF0IGFsbCB0aGUgY2FsbHMgdG8gdGhpcyBjbGFzcydzIG1ldGhvZCAnZm5OYW1lJ1xyXG5cdCMgYXJlIHRocm90dGxlZFxyXG5cdF90aHJvdHRsZUVtaXR0ZXJNZXRob2Q6IChmbk5hbWUsIHRpbWUgPSAxMDAwKSAtPlxyXG5cclxuXHRcdG9yaWdpbmFsRm4gPSBAW2ZuTmFtZV1cclxuXHJcblx0XHRpZiB0eXBlb2Ygb3JpZ2luYWxGbiBpc250ICdmdW5jdGlvbidcclxuXHJcblx0XHRcdHRocm93IEVycm9yIFwidGhpcyBjbGFzcyBkb2VzIG5vdCBoYXZlIGEgbWV0aG9kIGNhbGxlZCAnI3tmbk5hbWV9J1wiXHJcblxyXG5cdFx0bGFzdENhbGxBcmdzID0gbnVsbFxyXG5cdFx0cGVuZGluZyA9IG5vXHJcblx0XHR0aW1lciA9IG51bGxcclxuXHJcblx0XHRAW2ZuTmFtZV0gPSA9PlxyXG5cclxuXHRcdFx0bGFzdENhbGxBcmdzID0gYXJndW1lbnRzXHJcblxyXG5cdFx0XHRkbyBwZW5kXHJcblxyXG5cdFx0cGVuZCA9ID0+XHJcblxyXG5cdFx0XHRpZiBwZW5kaW5nXHJcblxyXG5cdFx0XHRcdGNsZWFyVGltZW91dCB0aW1lclxyXG5cclxuXHRcdFx0dGltZXIgPSBzZXRUaW1lb3V0IHJ1bkl0LCB0aW1lXHJcblxyXG5cdFx0XHRwZW5kaW5nID0geWVzXHJcblxyXG5cdFx0cnVuSXQgPSA9PlxyXG5cclxuXHRcdFx0cGVuZGluZyA9IG5vXHJcblxyXG5cdFx0XHRvcmlnaW5hbEZuLmFwcGx5IEAsIGxhc3RDYWxsQXJnc1xyXG5cclxuXHRfZGlzYWJsZUVtaXR0ZXI6IChmbk5hbWUpIC0+XHJcblxyXG5cdFx0aWYgQF9kaXNhYmxlZEVtaXR0ZXJzW2ZuTmFtZV0/XHJcblxyXG5cdFx0XHR0aHJvdyBFcnJvciBcIiN7Zm5OYW1lfSBpcyBhbHJlYWR5IGEgZGlzYWJsZWQgZW1pdHRlclwiXHJcblxyXG5cdFx0QF9kaXNhYmxlZEVtaXR0ZXJzW2ZuTmFtZV0gPSBAW2ZuTmFtZV1cclxuXHJcblx0XHRAW2ZuTmFtZV0gPSAtPlxyXG5cclxuXHRfZW5hYmxlRW1pdHRlcjogKGZuTmFtZSkgLT5cclxuXHJcblx0XHRmbiA9IEBfZGlzYWJsZWRFbWl0dGVyc1tmbk5hbWVdXHJcblxyXG5cdFx0dW5sZXNzIGZuP1xyXG5cclxuXHRcdFx0dGhyb3cgRXJyb3IgXCIje2ZuTmFtZX0gaXMgbm90IGEgZGlzYWJsZWQgZW1pdHRlclwiXHJcblxyXG5cdFx0QFtmbk5hbWVdID0gZm5cclxuXHJcblx0XHRkZWxldGUgQF9kaXNhYmxlZEVtaXR0ZXJzW2ZuTmFtZV0iXX0=